//=============================================================================
// VisuStella MZ - Options Core
// VisuMZ_1_OptionsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_OptionsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.OptionsCore = VisuMZ.OptionsCore || {};
VisuMZ.OptionsCore.version = 1.28;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.28] [OptionsCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Options_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Options Core plugin revamps the Options Menu Scene in RPG Maker MZ to be
 * more extensive and sustain a larger variety of options. This plugin will add
 * new options to the list in addition to options from other VisuStella MZ
 * plugins provided that they're installed as well. Game devs that are adept
 * with JavaScript are also able to add in their own options to the menu as
 * well.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Revamped Options Menu Scene and layout.
 * * The ability to add in your own Categories and options inside each of the
 *   individual categories.
 * * Newly added options like Master Volume, Window Tone support, and more.
 * * Integrated options added from other VisuStella MZ plugins.
 * * An added Playtest options category that is only available during test play
 *   to help speed up the game debug process.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Options Menu Scene
 *
 * - The whole scene is revamped due to all the new additions provided by the
 * Options Core plugin. While basic functions will still work, do not expect
 * everything to integrate into it seamlessly.
 *
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list. Most of these enable new options for the
 * Options Core to utilize as the code for them to work is found in the newer
 * plugins.
 *
 * ---
 *
 * Many VisuMZ Plugins
 * 
 * - Many VisuMZ plugins have options that become available when installed
 *   together with the Options Core plugin that wouldn't be available normally.
 * 
 * ---
 *
 * ============================================================================
 * Understanding Options
 * ============================================================================
 * 
 * This section is to clarify a few things about the Options Core.
 * 
 * ---
 * 
 * === Global Settings ===
 * 
 * The majority of settings adjusted by the player in the Options menu are
 * global settings. This is the way it is for base RPG Maker MZ without using
 * any plugins and this is the way it will be when using the Options Core.
 * 
 * What does this mean?
 * 
 * This means that if your player changed the Options settings, then loaded up
 * a different save, the Options settings do not revert to the settings from
 * the last time that save was made.
 * 
 * Why is this?
 * 
 * Because that is the industry standard. If the player wants to adjust the
 * BGM volume down to 50% from 100%, that means that when the player loads a
 * save file, the BGM volume does not shoot back up to 100%. Doing that would
 * require the player to adjust the settings multiple times for each save and
 * that just is not user friendly.
 * 
 * Therefore, the majority of the Options Core settings are global for this
 * very reason and are not going to change because of it.
 * 
 * ---
 * 
 * === Exceptions ===
 * 
 * There are a few exceptions to the rule. These exceptions are the three
 * settings that govern the "Window Tone" in the UI section.
 * 
 * This means the values inserted for "Red", "Green", and "Blue" are saved
 * relative to the save file's settings.
 * 
 * Why is this?
 * 
 * That's because RPG Maker MZ's "Change Window Color" event command does the
 * same thing and we have no intentions of altering how it behaves to keep the
 * otherwise-global aspect.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: General
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "General" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Exploration ===
 *
 * These options adjust the general exploration aspects of the game.
 *
 * ---
 *
 * Always Dash
 * - A default option that came with RPG Maker MZ.
 * - If ON, then this puts the player character in a constant state of dashing
 *   unless the Dash button is held down.
 *   - OFF: Walks normally. Holding down Dash button will make player dash.
 *   - ON: Dashes normally. Holding down Dash button will make player walk.
 *
 * ---
 *
 * Autosave
 * - Requires: VisuMZ_1_SaveCore
 * - Lets the player choose whether or not they want autosaving in their game.
 *   - OFF: Autosaves are disabled.
 *   - ON: Autosaves are enabled and occur at the set conditions.
 *
 * ---
 *
 * Show Compass
 * - Requires: VisuMZ_4_ProximityCompass
 * - Displays the Proximity Compass in the corner of the screen.
 *   - OFF: Compass is hidden.
 *   - ON: Compass is shown.
 * 
 * ---
 *
 * Compass Size
 * - Requires: VisuMZ_4_ProximityCompass
 * - Changes the size of the compass.
 *   - 50% for Smallest
 *   - 100% for Largest
 * 
 * ---
 * 
 * Show Date & Time
 * - Requires: VisuMZ_2_DateTimeSystem
 * - Displays the Date & Time HUD in the corner of the screen.
 *   - OFF: HUD is hidden.
 *   - ON: HUD is shown.
 * 
 * ---
 *
 * Show Quest Tracker
 * - Requires: VisuMZ_2_QuestSystem
 * - Player can choose if they want the Quest Tracker Window to appear on the
 *   map scene as they explore.
 *   - OFF: Quest Tracker Window does not appear.
 *   - ON: Quest Tracker Window is visible.
 *
 * ---
 *
 * Quest Tracker Position
 * - Requires: VisuMZ_2_QuestSystem
 * - Lets the player decide which half of the screen the Quest Tracker Window
 *   should appear.
 *   - ←: Quest Tracker Window appears on the left.
 *   - →: Quest Tracker Window appears on the right.
 *
 * ---
 *
 * Random Encounters
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * Show Tutorials
 * - Requires: VisuMZ_2_TutorialPanelSys
 * - Allows tutorials to interrupt gameplay in order to teach the player about
 *   whatever new mechanic needs to be done.
 *   - OFF: Tutorials won't turn on but can still be accessed from main menu.
 *   - ON: Tutorials will halt gameplay to teach the player.
 * 
 * ---
 *
 * === Battle ===
 *
 * These options adjust the general battle aspects of the game.
 *
 * ---
 * 
 * Show Battle Animations:
 * - Players might want to turn off or some battle animations for various
 *   reasons. As examples, battle animations may take a toll on some players'
 *   computers while others might find them too distracting.
 *   - OFF: All battle animations are turned off.
 *   - SOME: Animations that aren't part of a skill/item's action sequence will
 *     not be displayed.
 *   - ON: All battle animations are visible.
 * 
 * ---
 *
 * Battle Animation Speed:
 * - Battles can become a slog for some types of players. This option comes
 *   with four speed types to blaze through the battle while animations are
 *   playing. Fret not, if it's time for an actor to input actions, then the
 *   battle speed will temporarily revert to normal speed.
 *   - Normal: The usual battle speed.
 *   - Fast: x2 the usual battle speed.
 *   - Faster: x3 the usual battle speed.
 *   - Fastest: x4 the usual battle speed.
 *
 * ---
 *
 * Battle Camera
 * - Requires: VisuMZ_3_ActSeqCamera
 * - Allows the player to turn on/off the camera in case the player is one
 *   who gets motion sick easily.
 *   - OFF: Battle camera is static and doesn't move/zoom.
 *   - ON: Battle camera has full range of movement and zoom.
 *
 * ---
 *
 * Command Remember
 * - A default Options menu command that remembers the last position of the
 *   battle input window.
 *   - OFF: Cursor position resets each time the battle input window is active.
 *   - ON: Cursor position remembers last position for battle input window.
 *
 * ---
 *
 * Active Battle Style
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player switch betweent "Wait" and "Active".
 *   - Wait: ATB gauges stop filling up the moment an actor can input.
 *   - Active: ATB gauges keep filling even if actors can input.
 *
 * ---
 *
 * Active Battle Speed
 * - Requires: VisuMZ_2_BattleSystemATB
 * - Lets the player control how fast ATB gauges fill up.
 * - 1 for slowest.
 * - 5 for fastest.
 *
 * ---
 *
 * Auto Battle Start
 * - Requires: VisuMZ_1_BattleCore
 * - Start battles with Auto Battle on/off?
 *   - OFF: Battles do not start with Auto Battle on.
 *   - ON: Battles start with Auto Battle on.
 *
 * ---
 *
 * Auto Battle Style
 * - Requires: VisuMZ_1_BattleCore
 * - Determine if Auto Battle for the player party will attack only or be
 *   allowed to use skills as well.
 *   - Attack: Auto Battle actors will attack only.
 *   - Skills: Auto Battle actors can also use skills.
 * 
 * ---
 *
 * === Screen ===
 *
 * These options adjust the general screen-related aspects of the game.
 *
 * ---
 *
 * Display FPS
 * - Turns on/off the FPS counter in the upper left section of the screen.
 *
 * ---
 * 
 * Limit FPS
 * - Allows player to limit FPS counter. If ON, limit becomes 60. If off, the
 *   FPS counter is uncapped to whatever the player's monitor allows.
 * 
 * ---
 *
 * Full Screen
 * - Switches the game client between windowed mode and full screen.
 *
 * ---
 *
 * Stretch Screen
 * - If the game client is larger than the screen, then the game's canvas will
 *   stretch to fit the client. Turn this on or off.
 *
 * ---
 * 
 * Special Effects
 * - Requires: VisuMZ_2_BrightEffects and/or VisuMZ_2_HorrorEffects
 * - When using VisuStella MZ's Horror Effects or Bright Effects, users can opt
 *   to disable those effects by turning this option on/off.
 * 
 * ---
 * 
 * Dust Clouds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays dust cloud effects when the player and followers are running across
 *   the screen.
 * 
 * ---
 * 
 * Footprint Marks
 * - Requires: VisuMZ_2_MovementEffects
 * - Puts footprints down on the screen when the character sprites are moving
 *   on the screen.
 * 
 * ---
 * 
 * Smooth Scroll
 * - Requires: VisuMZ_2_MovementEffects
 * - Gradually shifts the screen camera to the player position.
 * 
 * ---
 * 
 * Blinking Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off blinking effect from lighting effects.
 * 
 * ---
 * 
 * Pulsing Lights
 * - Requires: VisuMZ_2_LightingEffects
 * - Turns off pulsing effect from Lighting effects.
 * 
 * ---
 * 
 * Weather Density
 * - Requires: VisuMZ_2_WeatherEffects
 * - Allows players to control the density of weather patterns if it may be too
 *   much for their devices to handle.
 * 
 * ---
 *
 * === Controls ===
 *
 * These options adjust the keyboard and controller buttons and what functions
 * are assigned to them. The player can use these commands to rebind them.
 * These settings require VisuMZ_0_CoreEngine and for rebindings to be enabled
 * in the Plugin Parameters.
 *
 * ---
 * 
 * Rebind Keyboard
 * - Requires: VisuMZ_0_CoreEngine
 * - Allows players to rebind their keyboard controls.
 * 
 * ---
 * 
 * Rebind Gamepad
 * - Requires: VisuMZ_0_CoreEngine
 * - Allows players to rebind their gameplad controls.
 *   - Gamepad must be connected.
 * 
 * ---
 *
 * ============================================================================
 * Options Category: Audio
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Audio" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Volume ===
 *
 * These options adjust the volume-related aspects of the game.
 *
 * ---
 *
 * Master Volume
 * - The master volume sets the volume of all the other volume types by a
 *   proportional amount from 0% to 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGM Volume
 * - Controls the background music volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * BGS Volume
 * - Controls the background ambience volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * ME Volume
 * - Controls the fanfare volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 *
 * ---
 *
 * SE Volume
 * - Controls the sound effect volume by a value between 0% and 100%.
 * - The Options Core allows players to adjust the volume in increments of 10%
 *   instead of the 20% by default.
 * 
 * ---
 * 
 * Voice Volume:
 * - Requires: VisuMZ_2_VoiceActControl
 * - Allows players to adjust the volume of the voice audio channel instead of
 *   having it linked to the SE audio channel. This is so players can choose to
 *   turn off sound effects while still hearing voices or vice versa.
 * 
 * ---
 * 
 * Voice Language:
 * - Requires: VisuMZ_2_VoiceActControl & Audio Languages enabled
 * - Allows players switch audio languages spoken by in-game characters.
 * 
 * ---
 * 
 * Advanced Sound Options
 * - Requires: Tome571/TF's "Advanced Sound Options plugin"
 * - Allows for very specialized control over sound settings.
 * - https://tome571.itch.io/advanced-audio-options-rmmz
 * 
 * ---
 *
 * === Sound Effects ===
 *
 * These options adjust the sound effects-related aspects of the game.
 *
 * ---
 * 
 * Battle Voices
 * - Requires: VisuMZ_3_BattleVoices
 * - Allows player to toggle the playing of battle voices in-battle.
 * 
 * ---
 * 
 * Footstep Sounds
 * - Requires: VisuMZ_2_MovementEffects
 * - Plays footstep sounds when the character sprites are moving on screen.
 * 
 * ---
 * 
 * Letter Sounds
 * - Requires VisuMZ_3_MessageSounds
 * - Allows player to toggle the playing of letter sounds for messages.
 * 
 * ---
 *
 * Sound Effects:
 * Cursor SFX:
 * Confirm SFX:
 * Cancel SFX:
 * Buzzer SFX:
 * - Not all sound effects register well with players and/or their computers.
 * - This lets players pick different sound effects if they have trouble
 *   hearing certain ones.
 *
 * ---
 *
 * ============================================================================
 * Options Category: UI
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "UI" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 *
 * === Windows ===
 *
 * These options adjust the Windows UI-related aspects of the game.
 *
 * ---
 *
 * Window Tone: Red:
 * Window Tone: Green:
 * Window Tone: Blue:
 * - Allows the player to adjust the Window Tone to their liking. This helps
 *   give players a more personal touch on their save file.
 *
 * ---
 *
 * === Text ===
 *
 * These options adjust the Text-related aspects of the game.
 *
 * ---
 * 
 * Text Language:
 * - Requires: VisuMZ_1_MessageCore & Text Languages to be enabled
 * - Allows the player to switch between different languages in the game.
 * - Languages are set up by the Message Core.
 * 
 * ---
 *
 * Text Font:
 * - Certain fonts are harder to read for different players. Let the players
 *   pick the font the game uses to allow themselves maximum comfort.
 *
 * ---
 *
 * Text Speed
 * - Requires: VisuMZ_1_MessageCore
 * - Allows the player to set the speed at which text displays during messages.
 * - There are speeds 1 through 10, with 1 being the slowest and 10 being the
 *   fastest.
 * - Speed 11 is "Instant" which causes text to display instantly.
 * 
 * ---
 * 
 * Text Effects
 * - Requires: VisuMZ_2_AniMsgTextEffects
 * - Allows the player to toggle animated text effects.
 *
 * ---
 *
 * === Touch Input ===
 *
 * These options adjust the Touch UI-related aspects of the game.
 *
 * ---
 *
 * Touch UI
 * - Requires VisuMZ_0_CoreEngine
 * - This sets the visibility of the UI elements that are touch-only in the
 *   game such as the cancel button and the left/right actor switch buttons.
 *   - OFF: The touch-only UI elements do not appear.
 *   - ON: The touch-only UI elements do appear.
 *
 * ---
 *
 * Button Position:
 * - Requires VisuMZ_0_CoreEngine
 * - Moves the clickable Cancel button, Page Up button, and Page down button
 *   to either the top of the screen or bottom of the screen.
 *
 * ---
 *
 * Hover Select:
 * - Turn on/off Hover Select when using the mouse. If Hover Select is on, then
 *   the window cursor will automatically follow the mouse when applicable.
 *   Otherwise, the player will have to manually move the cursor.
 *
 * ---
 *
 * === Menu Arrangement ===
 *
 * These options adjust the Menu Arrangement-related aspects of the game.
 *
 * ---
 *
 * Menu Style
 * - Switch between 'Recommended' and 'Custom'. Recommended will have the menus
 *   arranged in the way the game/plugins decide for them to be. Otherwise,
 *   the player will be able to customize the positions of these next windows:
 *
 * ---
 *
 * Help Window Position:
 * Input Window Position:
 * - Adjust the positions of these windows in the various positions listed to
 *   allow the player to select what they're most comfortable with.
 *
 * ---
 *
 * === Battle UI ===
 *
 * These options adjust the Battle UI-related aspects of the game.
 *
 * ---
 *
 * Show Provoke Origin
 * - Requires VisuMZ_2_AggroControlSystem
 * - If a battler is under the effects of "Provoke", then a line tracing back
 *   to the origin of the "Provoke" effect can be found.
 *   - OFF: Hide the Provoke Origin lines.
 *   - ON: Show the Provoke Origin lines.
 *
 * ---
 *
 * Show Aggro Gauge
 * - Requires VisuMZ_2_AggroControlSystem
 * - Displays the amount of aggro a party member has with a gauge.
 *   - OFF: The Aggro Gauge is hidden.
 *   - ON: The Aggro Gauge is visible.
 *
 * ---
 *
 * Show HP Gauges
 * - Requires VisuMZ_3_VisualHpGauge
 * - Displays the amount of HP each battler has with a gauge under their feet.
 *   - OFF: The battlefield's HP Gauges are hidden.
 *   - ON: The battlefield's HP Gauges are visible.
 *
 * ---
 *
 * Show ATB Gauges
 * - Requires VisuMZ_2_BattleSystemATB
 * - Displays ATB gauges on each battler showing how much time they have left
 *   before they can act.
 *   - OFF: The battlefield's ATB Gauges are hidden.
 *   - ON: The battlefield's ATB Gauges are hidden.
 *
 * ---
 *
 * ============================================================================
 * Options Category: Playtest
 * ============================================================================
 *
 * The following are the options that have been added to the Options Menu. This
 * is the default "Text" category that appears with the plugin parameters.
 * These can be added and/or removed. If a new option has been added through an
 * update, then there's a likelihood of it not appearing due to the plugin
 * parameters not being updated with them.
 * 
 * *NOTE* Unless changed, this category only appears during playtesting and
 * does not appear outside of playtesting, which means deployed games should
 * not display this unless you've given them access to playtest mode.
 *
 * === Effects ===
 * 
 * ---
 *
 * Playtest Effects:
 * - If this is 'OFF', then all the Playtesting options are turned off. If 'ON'
 *   then you can adjust them however you like.
 *
 * ---
 * 
 * === Exploration ===
 * 
 * These options adjust the Playtest Exploration-related aspects of the game.
 * 
 * ---
 *
 * Map Update Speed:
 * - Allows you to speed up the events and movement on the map with four speed
 *   levels ranging from normal to x3 speed.
 *   - Normal: The usual update speed.
 *   - Fast: x2 the usual update speed.
 *   - Faster: x3 the usual update speed.
 *   - Fastest: x4 the usual update speed.
 *
 * ---
 *
 * Random Encounters:
 * - Sometimes, random encounters can really take away the enjoyment a player
 *   has for the game if it's too frequent. This option lets the player turn
 *   them off or reduce their frequency by half.
 *   - None: No random encounters while this is selected.
 *   - Half: Random encounters occur at half frequency.
 *   - Normal: Random encounters occur at normal frequency.
 *
 * ---
 * 
 * === Battle ===
 * 
 * These options adjust the Playtest Battle-related aspects of the game.
 * 
 * ---
 *
 * God Mode:
 * - If this is ON, then actors will be unable to die even if their HP reaches
 *   0. They will continue to act as if they still have HP left.
 *
 * ---
 *
 * Resist Negative Effects:
 * - Requires VisuMZ_1_SkillsStatesCore.
 * - If ON, this will resist states with a <Negative State> notetag.
 * - If ON, this will also resist debuffs.
 *
 * ---
 *
 * Instant K.O.
 * - If ON, then actors attacking enemies will deal fatal damage to enemies.
 *
 * ---
 *
 * Skill Costs:
 * Consume Items:
 * - If OFF, then skills won't cost anything and items won't be consumed.
 *
 * ---
 * 
 * === Rewards ===
 * 
 * These options adjust the Playtest Rewards-related aspects of the game.
 * 
 * ---
 *
 * EXP Multiplier:
 * Gold Multiplier:
 * Drop Multiplier:
 * - Allows you to adjust the multipliers for EXP gained, Gold gained, and
 *   Drop rates from x2 to x1024.
 *
 * ---
 * 
 * === Spawners ===
 * 
 * These options adjust the Playtest Spawner-related aspects of the game.
 * 
 * ---
 *
 * Spawn Items:
 * Spawn Weapons:
 * Spawn Armors:
 * - Sends you to a "shop" where you can purchase any of the game's named items
 *   for 0 gold each.
 *
 * ---
 * 
 * === Debug ===
 * 
 * These options adjust the Playtest Debug-related aspects of the game.
 * 
 * ---
 *
 * Debug Menu:
 * - Sends you to the Debug Menu Scene.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Settings
 * ============================================================================
 *
 * Allows you to adjust some default settings that may affect the way the
 * Options Menu Scene looks and/or some of the options available inside it.
 *
 * ---
 *
 * Categories
 * 
 *   Category Window Style:
 *   - How do you wish to draw commands in the Category Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Category Text Align:
 *   - Text alignment for the Command Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *
 * ---
 * 
 * Options Window
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 * ---
 *
 * Button Assist Window
 *
 *   Switch Category:
 *   - Button assist text used for switching categories.
 *   - For VisuStella MZ's Core Engine's Button Assist Window.
 * 
 *   Background Type:
 *   - Select background type for this window.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Sound
 * 
 *   Cursor Sounds:
 *   OK Sounds:
 *   Cancel Sounds:
 *   Buzzer Sounds:
 *   - SE files player can select from for OK SE.
 *   - The first in the list will always be the default SE.
 *
 * ---
 *
 * Text
 * 
 *   Font Options:
 *   - Available fonts for the player to select from.
 *   - The first font in the list is always be the default font.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Options Categories
 * ============================================================================
 *
 * Here, you can add/edit/remove the categories found in the Options Menu Scene
 * and their related Options.
 *
 * ---
 *
 * Options Categories
 * 
 *   Name:
 *   - The name of this category as seen in the Category Window.
 *   - Text codes are supported.
 * 
 *   Icon:
 *   - Icon used for this category.
 *   - Use 0 for no icon.
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this category is visible.
 * 
 *   Options List:
 *   - Add options to this category here.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Listed Options
 * ============================================================================
 *
 * These are the Options found within an Options Category's List. Add, edit,
 * and/or remove them as you see fit. Adding or altering an option will require
 * adequate knowledge of JavaScript to do so.
 *
 * ---
 *
 * Basic
 * 
 *   Symbol:
 *   - Symbol used for this option when selected.
 *   - Make sure this is unique from other symbols.
 * 
 *   Icon:
 *   - Icon used for this option.
 *   - Use 0 for no icon.
 * 
 *   STR: Text:
 *   - Displayed text used for this option.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 *
 * ---
 *
 * Accessibility
 * 
 *   JS: Show/Hide:
 *   - Code used to determine if this option is visible.
 * 
 *   JS: Enable:
 *   - Code used to determine if this option is enabled.
 *   - This does NOT determine the ON/OFF value of the option. It instead
 *     determines if the option can be changed (enabled) or not (disabled).
 * 
 *   JS: Ext:
 *   - Code used to determine if this option's ext value.
 *
 * ---
 *
 * Functions
 * 
 *   JS: Draw Option:
 *   - Code used to draw this item into the List Window.
 * 
 *   JS: Process OK:
 *   - Code used when OK button is pressed while selected.
 * 
 *   JS: Cursor Right:
 *   - Code used when Right button is pressed while selected.
 * 
 *   JS: Cursor Left:
 *   - Code used when Left button is pressed while selected.
 *
 * ---
 *
 * Data
 * 
 *   JS: Default Value:
 *   - Code used to determine the default value of this option.
 *   - This is what determines the default ON/OFF values of an option.
 * 
 *   JS: Save Option:
 *   - Code used when saving this options setting.
 * 
 *   JS: Load Option:
 *   - Code used when loading this options setting.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Keyboard/Controller Rebind Settings
 * ============================================================================
 *
 * Requires VisuMZ_0_CoreEngine!
 * 
 * These new Options Core menu commands will take the player to new scenes
 * where the players can rebind their keyboard or controller settings. This
 * will require the VisuStella MZ Core Engine in order to work.
 * 
 * ==== Keyboard Limitations ====
 * 
 * Not all keyboard keys are eligible for rebinding. Only a certain set of
 * keys are allowed. They are the following:
 * 
 *   - Numbers on the top row from 1 through 0.
 *   - Tilde (~), Minus (-), Plus/Equals (+/=)
 *   - Keys A through Z
 *   - [ ] \ ; ' < > /
 * 
 * The reason why only these keys are available is to avoid hitting any other
 * system bound keys like the function keys, caps lock, etc. These will also
 * function as a second set of controls with default controls bound to the
 * arrow keys, Enter, Space, Escape, and Numpad. This way, the player cannot
 * softlock themselves out of the key rebinding scene.
 * 
 * ---
 * 
 * ==== Gamepad Limitations ====
 * 
 * Just like the keyboard, not everything on the controller is eligible for
 * rebinding. However, the limitations are much less as the limitations are
 * only forbidden from rebinding the D-Pad. The reason for this is due to how
 * D-Pad actions may be hardcoded for some controllers and are better left
 * alone instead.
 * 
 * Gamepads cannot remove individual keys from bindings like keyboards can.
 * This is because there's no fallback key that would prevent a softlock from
 * happening. Instead, they get a function to reset the controller.
 * 
 * ---
 * 
 * ==== Late Retroactive Updating of WASD ====
 * 
 * ---
 * 
 * If you've decided to enable Keyboard/Controller Rebind, decided to enable
 * VisuMZ Core Engine's "WASD Movement" after your project has config.rmmzsave
 * in your project's /save/ folder, then the newly added 'WASD Controls' will
 * NOT be updated retroactively.
 * 
 * This can be remedied in one of two ways:
 * 
 * 1. Go into your keybindings and add them in manually (arrow keys still
 *    retain functionality). You may need to readjust the "Shift Right" option,
 *    too. 
 * 
 * 2. Delete the config.rmmzsave file from /save/ and the game will generate
 *    you a new one with the updated "WASD Movement" controls.
 * 
 * This retroactive non-update will only affect your players if they've already
 * begun playing your game with a version before "WASD Movement" was enabled
 * and has a config.rmmzsave file already made. Players that are affected by
 * this can just simply update and add the 'WASD controls' on their own.
 * 
 * Otherwise, a new player would not experience this at all.
 * 
 * ---
 * 
 * ==== Plugin Parameters ====
 *
 * ---
 *   
 * General Settings:
 *   
 *   Enable Rebinding?:
 *   - Enable keyboard and controller rebinding?
 *   - Requires VisuMZ_0_CoreEngine!
 *   
 *   Keyboard Bindings:
 *   - Select the keys that can be rebound and the order they appear for
 *     keyboard. 
 *   
 *   Gamepad Bindings:
 *   - Select the keys that can be rebound and the order they appear for
 *     gamepad. 
 *   
 *     JS: Reset Gamepad:
 *     - Determine how the gamepad map should be when reset. 
 * 
 * ---
 *   
 * Vocabulary:
 *   
 *   Button Vocab:
 *   
 *     Up:
 *     Left:
 *     Down:
 *     Right:
 *     OK:
 *     Escape:
 *     Cancel:
 *     Menu:
 *     Page Up:
 *     Page Down:
 *     Shift:
 *     Tab:
 *     - Text used to represent this input type. Text codes allowed.
 * 
 *     Button Format:
 *     - Text format for unassigned gamepad buttons.
 *     - Text codes allowed.
 *     - %1 - Button ID.
 *   
 *     D-Pad Format:
 *     - Text format for directional pad buttons.
 *     - Text codes allowed.
 *     - %1 - Direction.
 *   
 *   Button Assist:
 *   
 *     Shift: Remove:
 *     Shift: Reset:
 *     OK: Select:
 *     Cancel: Exit:
 *     - Text used to represent this button assist. 
 *   
 *   Help Descriptions:
 *   
 *     Select for Keyboard:
 *     - Help description used for selecting a keyboard button.
 *     - Text codes allowed.
 *   
 *     Keyboard Instruct:
 *     - Help description used to ask for a key to press.
 *     - Text codes allowed.
 *   
 *     Forbidden Key:
 *     - Help description used when a keyboard key cannot be used.
 *     - Text codes allowed.
 *   
 *     Select for Gamepad:
 *     - Help description used for selecting a gamepad button.
 *     - Text codes allowed.
 *   
 *     Gamepad Instructions:
 *     - Help description used to ask for a gamepad button to press.
 *     - Text codes allowed.
 *   
 *     Forbidden Button:
 *     - Help description used when a gamepad button cannot be reassigned.
 *     - Text codes allowed.
 *   
 *     No Gamepad Detected:
 *     - Help description used when no gamepad is detected.
 *     - Text codes allowed.
 * 
 * ---
 *   
 * Window Settings:
 *   
 *   Window_Help:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *   Window_KeyRebinds:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *     Key Type Align:
 *     - Text alignment for the key types? 
 *   
 *     Rebind Key Align:
 *     - Text alignment for the rebind key? 
 *   
 *     JS: X, Y, W, H:
 *     - Code used to determine the dimensions for this window. 
 *   
 *   Window_RebindHelp:
 *   
 *     Background Type:
 *     - Select background type for this window. 
 *   
 *     JS: X, Y, W, H:
 *     - Code used to determine the dimensions for this window. 
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Master Volume Shortcut Settings
 * ============================================================================
 *
 * Settings regarding the Master Volume Shortcut keys. Requires the
 * Options Core to allow players to adjust the master volume.
 * 
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 *
 * ---
 *
 * Shortcut
 * 
 *   Enabled?:
 *   - Enable the shortcut?
 *   - Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 *   Shortcut Change Value:
 *   - What is the change amount for the shortcut key?
 *   - Master volume caps at 0 and 100.
 *
 * ---
 *
 * Sound Effects > Volume Up
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * Sound Effects > Volume Down
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.28: February 20, 2025
 * * Feature Update!
 * ** Added a fail safe to prevent crashes when pressing F4/Full Screen too
 *    early while the game is loading. Update made by Arisu.
 * 
 * Version 1.27: December 19, 2024
 * * Documentation Update!
 * ** Added new section in help file for "Keyboard/Controller Rebind Settings":
 * *** Late Retroactive Updating of WASD
 * **** If you've decided to enable Keyboard/Controller Rebind, decided to
 *      enable VisuMZ Core Engine's "WASD Movement" after your project has
 *      config.rmmzsave in your project's /save/ folder, then the newly added
 *      'WASD Controls' will NOT be updated retroactively.
 * **** This can be remedied in one of two ways:
 * ***** 1. Go into your keybindings and add them in manually (arrow keys still
 *       retain functionality). You may need to readjust the "Shift Right"
 *       option, too. 
 * ***** 2. Delete the config.rmmzsave file from /save/ and the game will
 *       generate you a new one with the updated "WASD Movement" controls.
 * **** This retroactive non-update will only affect your players if they've
 *      already begun playing your game with a version before "WASD Movement"
 *      was enabled and has a config.rmmzsave file already made. Players that
 *      are affected by this can just simply update and add the 'WASD controls'
 *      on their own.
 * **** Otherwise, a new player would not experience this at all.
 * 
 * Version 1.26: July 18, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** Keyboard and Controller Rebinding added!
 * *** New General Option added: "Limit FPS"
 * **** Allows player to limit FPS counter. If ON, limit becomes 60. If off,
 *      the FPS counter is uncapped to whatever the player's monitor allows.
 * *** New Plugin Parameters added for Keyboard and Controller Rebinding.
 * **** See help file for more information.
 * *** Added Keyboard and Controller Rebinding access to Options menu.
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the "General" plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * 
 * Version 1.25: January 18, 2024
 * * Compatibility Update!
 * ** Added compatibility for Message Core's new Text Language options:
 * ** Added compatibility for Voice Acting Control's Voice Language options:
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the "Audio" and "UI" plugin parameters found in the Options
 *      Category plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.24: December 14, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Date & Time System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.23: June 15, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Voice Acting Control and Battle Voices
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio plugin parameters found in the Options Category
 *      plugin parameter settings to your current project.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.22: January 20, 2023
 * * Added compatibility functionality for future plugin:
 * ** Animated Message Text Effects
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the UI plugin parameters found in the Options Category plugin
 *      parameter settings to your current project.
 * 
 * Version 1.21: October 27, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Added compatibility functionality for future plugin:
 * ** Tutorial Panel System
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * * New Features!
 * ** Added "Master Volume Shortcut" Plugin Parameters.
 * *** Change the master volume anywhere in the game as long as the Options
 *     Core allows players to adjust the Master Volume.
 * *** Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * 
 * Version 1.20: September 15, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Button Assist Window no longer follows the Core Engine's Option Scene
 *    settings, but instead follows the Button Assist Window's settings.
 *    Update made by Arisu.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Parameters > Options Settings > Categories > Background Type
 * *** Parameters > Options Settings > Options Window > Background Type
 * *** Parameters > Options Settings > Button Assist Window > Background Type
 * **** Select background type for this window.
 * 
 * Version 1.19: August 11, 2022
 * * Feature Update!
 * ** VisuMZ Core Engine menu layout window settings now apply to all windows
 *    found in the Options Scene. Update made by Arisu.
 * 
 * Version 1.18: March 3, 2022
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins: "Movement Effects",
 *    "Weather Effects", and "Lighting Effects". Hold on tight!
 * *** If you want to acquire these settings for an already-existing project,
 *     do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General and Audio settings found in the Options Category
 *      plugin parameter to your current project.
 * 
 * Version 1.17: December 30, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 * ** Yep, again again.
 * ** We had to call in the big boss to fix this.
 * 
 * Version 1.16: December 23, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * ** Yep, again.
 * 
 * Version 1.15: December 16, 2021
 * * Bug Fixes!
 * ** Residual old code is now disabled from appearing on deployed projects if
 *    any carry over config data is brought over from the playtesting phase.
 *    Fix made by Arisu.
 * 
 * Version 1.14: December 9, 2021
 * * Compatibility Update!
 * ** Full Screen options have been updated to match the newest version of RPG
 *    Maker MZ's NodeJS client. Update made by Olivia.
 * *** The "Full Screen" settings have been updated in General settings. If
 *     you want to acquire these updated settings for an already-existing
 *     project, do either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.13: April 23, 2021
 * * Documentation Update!
 * ** Added clarity for some of the JS plugin parameters:
 * *** JS: Enable:
 * **** This does NOT determine the ON/OFF value of the option. It instead
 *      determines if the option can be changed (enabled) or not (disabled).
 * *** JS: Default Value:
 * **** This is what determines the default ON/OFF values of an option.
 * 
 * Version 1.12: April 9, 2021
 * * Bug Fixes!
 * ** Turning Touch UI off should no longer disable the Button Assist Text for
 *    the Page Up/Down buttons from the Core Engine. Fix made by Olivia.
 * 
 * Version 1.11: April 2, 2021
 * * Bug Fixes!
 * ** Default "Special Effects" option added in v1.10 should now have a fixed
 *    load data sequence that does not force open the FPS counter. To acquire
 *    the fixed settings, do either of the following:
 * *** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * *** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added "Understanding Options" section.
 * ** Options Category: General section updated with "Special Effects" which
 *    was left out of the v1.10 update.
 * * Feature Update!
 * ** Default settings will now run regardless of undefined setting provided
 *    that their other conditions for usage have showed up first. This is to
 *    reduce confusion for users. Update made by Yanfly.
 * 
 * Version 1.10: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility for VisuStella MZ Bright Effects and Horror Effects.
 * *** "Special Effects" option allows users to turn on/off filters applied by
 *     the Bright Effects and Horror Effects plugins.
 * *** The "Special Effects" settings have been added to General settings. If
 *     you want to acquire these settings for an already-existing project, do
 *     either of the following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the General settings found in the Options Category plugin
 *      parameter to your current project.
 * * Documentation Update!
 * ** Added Bright Effects and Horror Effects to the list of plugins with Extra
 *    Features. Update made by Olivia.
 * 
 * Version 1.09: January 29, 2021
 * * Compatibility Update
 * ** Added compatibility for Tome571/TF's "Advanced Sound Options plugin".
 * *** Default settings have been added to the Audio settings. If you want to
 *     acquire these settings for an already-existing project, do either of the
 *     following:
 * **** Delete the existing VisuMZ_1_OptionsCore.js in the Plugin Manager list
 *      and install the newest version.
 * **** Or create a new project, install VisuMZ_1_OptionsCore.js there, then
 *      copy over the Audio settings found in the Options Category plugin
 *      parameter to your current project.
 * 
 * Version 1.08: January 8, 2021
 * * Bug Fixes!
 * ** JS: Enabled accessibility option should now be working properly.
 * * Feature Update!
 * ** Disabled options should now be faded out completely.
 * 
 * Version 1.07: November 15, 2020
 * * Optimization update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: November 8, 2020
 * * Feature Update!
 * ** Modern Controls compatibility with Core Engine no longer enables the
 *    Item Categories window and child classes to utilize the Home/End keys.
 *
 * Version 1.05: October 18, 2020
 * * Optimization update!
 * 
 * Version 1.04: September 27, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.03: September 20, 2020
 * * Compatibility Update!
 * ** This plugin should offer better compatibility for future plugins!
 *    Update made by Yanfly.
 * 
 * Version 1.02: September 13, 2020
 * * Optimization Update!
 * ** Scrolling through menus should consume less resources.
 * 
 * Version 1.01: August 30, 2020
 * * Bug Fixes!
 * ** Before, already existing Options available in the RPG Maker MZ base code
 *    such as BGM Volume, Command Remember, Always Dash, and so on, would not
 *    have their default values declared through the Options Core. The Options
 *    Core now changes this functionality and gives priority to the Plugin
 *    Parameter settings declared by the game dev. Fix made by Yanfly.
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param OptionsSettings:struct
 * @text Options Settings
 * @type struct<OptionsSettings>
 * @desc General settings pertaining to options found here.
 * @default {"Categories":"","CategoryStyle:str":"auto","CategoryTextAlign:str":"center","Sound":"","SFXCursorList:arraystr":"[\"Default\",\"Book2\",\"Coin\",\"Cursor1\",\"Cursor2\",\"Hammer\",\"Key\",\"Knock\",\"Open1\",\"Open2\",\"Open3\",\"Paralyze1\"]","SFXOKList:arraystr":"[\"Default\",\"Bell3\",\"Computer\",\"Decision2\",\"Flash1\",\"Bell3\",\"Cat\",\"Item1\",\"Item2\",\"Item3\",\"Ice4\",\"Decision1\"]","SFXCancelList:arraystr":"[\"Default\",\"Absorb1\",\"Book1\",\"Cancel1\",\"Cancel2\",\"Raise2\",\"Skill1\",\"Dog\",\"Shot2\",\"Ice3\",\"Magic1\",\"Magic2\"]","SFXBuzzerList:arraystr":"[\"Default\",\"Buzzer2\",\"Fall\",\"Skill2\",\"Shot3\",\"Bell1\",\"Crow\",\"Horn\",\"Ice2\",\"Magic3\",\"Open4\",\"Buzzer1\"]","Text":"","FontFaces:arraystr":"[\"Default\",\"Arial\",\"Candara\",\"Calibri\",\"Garamond\",\"Georgia\",\"Gill Sans MT\",\"Helvetica\",\"Impact\",\"Lato\",\"Rockwell\",\"Segoe UI\",\"Tahoma\",\"Times\",\"Trebuchet MS\",\"Verdana\"]","ButtonAssist":"","buttonAssistCategory:str":"Switch Category"}
 *
 * @param Categories:arraystruct
 * @text Options Categories
 * @type struct<Categories>[]
 * @desc Add categories and their options here.
 * @default ["{\"Name:str\":\"General\",\"Icon:num\":\"245\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"alwaysDash\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.alwaysDash;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autosave\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autosaveOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_SaveCore &&\\\\\\\\\\\\\\\\n    VisuMZ.SaveCore.Settings.AutosaveOption.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showCompass\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.showCompass;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"compassSize\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"222\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.compassSize;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_4_ProximityCompass &&\\\\\\\\\\\\\\\\n    VisuMZ.ProximityCompass.Settings.Options.AddSizeOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(20);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(21);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 50;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(50, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(50, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dateTimeHud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"70\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.dateTimeHud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_DateTimeSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.DateTimeSystem.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerShow;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"questTrackerPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"186\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.questTrackerPosition;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_QuestSystem &&\\\\\\\\\\\\\\\\n    VisuMZ.QuestSystem.Settings.Tracker.AddShowOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = TextManager.questTrackerPosOff;\\\\\\\\\\\\\\\\nconst on  = TextManager.questTrackerPosOn;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"randomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"showTutorials\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.tutorial.optionsCmd;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_TutorialPanelSys &&\\\\\\\\\\\\\\\\n    VisuMZ.TutorialPanelSys.Settings.Options.AddTutorialsOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniShow\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Show Battle Animations';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_OptionsCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst showText = ['OFF', 'SOME', 'ON'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = showText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleAniSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Battle Animation Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleCameraOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_3_ActSeqCamera && VisuMZ.ActSeqCamera.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"commandRemember\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.commandRemember;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbActive\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Wait';\\\\\\\\\\\\\\\\nconst on  = 'Active';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = $dataSystem.battleSystem === 1;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"atbSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Active Battle Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BattleSystemATB && BattleManager.isATB();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 5;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.ctGaugeColor1();\\\\\\\\\\\\\\\\nconst color2 = ColorManager.ctGaugeColor2();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nfor (let i = 1; i <= 5; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(true);\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * (i - 1));\\\\\\\\\\\\\\\\n    this.contents.fillRect(sx, gy, segment, 12, color0);\\\\\\\\\\\\\\\\n    if (value >= i) this.contents.gradientFillRect(sx + 1, gy + 1, segment - 2, 10, color1, color2);\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    this.drawText(i, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 5 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 5);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 5);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 3;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 5);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleAtStart\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStart;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"autoBattleUseSkills\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.autoBattleStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.AutoBattle.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = VisuMZ.BattleCore.Settings.AutoBattle.StyleOFF;\\\\\\\\\\\\\\\\nconst on  = VisuMZ.BattleCore.Settings.AutoBattle.StyleON;\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"displayFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Display FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nif (!value) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"none\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (config[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._boxDiv.style.display = \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"block\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n    Graphics._fpsCounter._showFps = true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"limitFPS\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Limit FPS\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) SoundManager.playCursor();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = ConfigManager[symbol] ? 60 : 0;\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) SoundManager.playCursor();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nGraphics._app.ticker.maxFPS = config[symbol] ? 60 : 0;\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"fullScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Full Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Utils.isNwjs();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Window Mode';\\\\\\\\\\\\\\\\nconst on  = 'Full Screen';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._requestFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._cancelFullScreen();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"stretchScreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Stretch Screen\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._isFullScreen();\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nGraphics._switchStretchMode();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n    Graphics._updateAllElements();\\\\\\\\\\\\\\\\n    Graphics._stretchScreenOptionsCore();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = !!Graphics._stretchEnabled;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\\nif (ConfigManager[symbol]) {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = true;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    Graphics._stretchEnabled = false;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nGraphics._updateAllElements();\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"specialEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Special Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_BrightEffects ||\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_HorrorEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"dustCloud\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"160\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.DustCloud;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddDustCloud\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footprints\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footprints;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddFootprints\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"smoothCamera\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.SmoothCamera;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"blinkingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.BlinkingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddBlinkingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"pulsingLights\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"214\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.LightingEffectsOptions.PulsingLights;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_LightingEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.LightingEffects.Settings.Options.AddPulsingLights\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"weatherDensity\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"65\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.weatherDensity;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_WeatherEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.WeatherEffects.Settings.Options.AddWeatherDensityOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(0);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"rebindKeyboard\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"245\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Rebind Keyboard Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_RebindKeyboard);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"rebindGamepad\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Rebind Gamepad Controls\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_RebindGamepad);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn this.isRebindingEnabled();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Audio\",\"Icon:num\":\"80\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"masterVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Master Volume\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(22);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(23);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    WebAudio.setMasterVolume(value / 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 100;\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(100 / 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\\nWebAudio.setMasterVolume(ConfigManager[symbol] / 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgmVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgmVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconsole.log((Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked()))\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"bgsVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.bgsVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"meVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.meVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.seVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"voiceVolume\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.voiceVolume;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_VoiceActControl;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 100).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(26);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(27);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = '%1%'.format(value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 100 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 100);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 10;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 100);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 40;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 100);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"voiceLocale\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.voiceLocale;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_VoiceActControl &&\\\\\\\\\\\\\\\\n    AudioManager.isVisuMzLocalizationEnabled &&\\\\\\\\\\\\\\\\n    AudioManager.isVisuMzLocalizationEnabled() &&\\\\\\\\\\\\\\\\n    VisuMZ.VoiceActControl.Settings.Localization.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.getAudioLanguageAt(-1) || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.getCurrentAudioLanguage() || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.getAudioLanguageAt(1) || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(true, true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzVoiceLocale(false);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"TF_AdvSoundOptions\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Advanced Sound Options\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.TFAdvancedSoundOptions;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\\nSceneManager.push(Scene_TFAudioOptions);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nif (Imported.TFAdvancedSoundOptions) {\\\\\\\\\\\\\\\\n    config.freq1Gain = TF._audio_1Gain || 0;\\\\\\\\\\\\\\\\n    config.freq2Gain = TF._audio_2Gain || 0;\\\\\\\\\\\\\\\\n    config.freq3Gain = TF._audio_3Gain || 0;\\\\\\\\\\\\\\\\n    config.freq4Gain = TF._audio_4Gain || 0;\\\\\\\\\\\\\\\\n    config.freq5Gain = TF._audio_5Gain || 0;\\\\\\\\\\\\\\\\n    config.freq6Gain = TF._audio_6Gain || 0;\\\\\\\\\\\\\\\\n    config.freq7Gain = TF._audio_7Gain || 0;\\\\\\\\\\\\\\\\n    config.freq8Gain = TF._audio_8Gain || 0;\\\\\\\\\\\\\\\\n    config.freq9Gain = TF._audio_9Gain || 0;\\\\\\\\\\\\\\\\n    config.preset = TF._audio_preset || \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"Preset\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Sound Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"battleVoices\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.battleVoices;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_BattleVoices &&\\\\\\\\\\\\\\\\n    VisuMZ.BattleVoices.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"footsteps\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"141\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.MovementEffectsOptions.Footsteps;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_MovementEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.MovementEffects.Settings.Options.AddSmoothCamera\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"msgLetterSound\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Letter Sounds\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_3_MessageSounds\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCursor\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cursor SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cursor %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cursor %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cursorSFXs.length ? 'Cursor %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cursorSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCursor();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seOK\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Confirm SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Confirm %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Confirm %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.okSFXs.length ? 'Confirm %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.okSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playOk();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seCancel\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Cancel SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Cancel %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Cancel %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.cancelSFXs.length ? 'Cancel %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.cancelSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playCancel();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"seBuzzer\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"78\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Buzzer SFX\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = (value - 1) >= 0 ? 'Buzzer %1'.format(value) : '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = 'Buzzer %1'.format(value + 1);\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = (value + 1) < SoundManager.buzzerSFXs.length ? 'Buzzer %1'.format(value + 2) : '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = SoundManager.buzzerSFXs.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    const volume = ConfigManager.seVolume;\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = 100;\\\\\\\\\\\\\\\\n    SoundManager.playBuzzer();\\\\\\\\\\\\\\\\n    ConfigManager.seVolume = volume;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"UI\",\"Icon:num\":\"79\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn true;\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Windows\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneRed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"162\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Red\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(10);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(2);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[0];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[0] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneGreen\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"164\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Green\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[1];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[1] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"windowToneBlue\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"165\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Window Tone: Blue\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = ((value + 255) / (255 * 2)).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(12);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(4);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = value;\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 255 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = -255;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\n    value = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = $gameSystem.windowTone()[2];\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= Input.isPressed(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"shift\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") ? 1 : 5;\\\\\\\\\\\\\\\\nvalue = value.clamp(-255, 255);\\\\\\\\\\\\\\\\n$gameSystem.windowTone()[2] = value;\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Text\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textLocale\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"189\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreLocalization;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    TextManager.isVisuMzLocalizationEnabled &&\\\\\\\\\\\\\\\\n    TextManager.isVisuMzLocalizationEnabled() &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.Localization.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.getLanguageAt(-1) || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.getCurrentLanguage() || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.getLanguageAt(1) || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(true, true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(true);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"this.changeVisuMzTextLocale(false);\\\\\\\\\\\\\\\\nthis.refreshWindows();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textFont\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Text Font\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 1\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name1 = TextManager.optionsCoreFonts[value - 1] || '-----';\\\\\\\\\\\\\\\\nconst fx1 = rect.x + halfWidth + (segment * 0);\\\\\\\\\\\\\\\\nthis.drawText(name1, fx1, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 2\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nconst name2 = TextManager.optionsCoreFonts[value] || '-----';\\\\\\\\\\\\\\\\nconst fx2 = rect.x + halfWidth + (segment * 1);\\\\\\\\\\\\\\\\nthis.drawText(name2, fx2, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Font Name 3\\\\\\\\\\\\\\\\nthis.changePaintOpacity(false);\\\\\\\\\\\\\\\\nconst name3 = TextManager.optionsCoreFonts[value + 1] || '-----';\\\\\\\\\\\\\\\\nconst fx3 = rect.x + halfWidth + (segment * 2);\\\\\\\\\\\\\\\\nthis.drawText(name3, fx3, rect.y, segment, 'center');\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nif (value >= length && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, length);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nconst length = TextManager.optionsCoreFonts.length - 1;\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, length);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refreshWindows();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"225\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.messageCoreTextSpeed;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_1_MessageCore &&\\\\\\\\\\\\\\\\n    VisuMZ.MessageCore.Settings.TextSpeed.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(value > 10 ? 20 : 28);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(value > 10 ? 21 : 29);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = this.textSpeedStatusText();\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 11 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 1;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(1, 11);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(1, 11);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = VisuMZ.MessageCore ? VisuMZ.MessageCore.Settings.TextSpeed.Default : 10;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(1, 11);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"textEffects\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"79\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.textEffects;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    Imported.VisuMZ_2_AniMsgTextEffects &&\\\\\\\\\\\\\\\\n    VisuMZ.AniMsgTextEffects.Settings.Options.AddOption\\\\\\\\\\\\\\\\n);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Touch Input\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"touchUI\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.touchUI;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonVisibility();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonVisibility();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiButtonPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Button Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nif (Imported.VisuMZ_0_CoreEngine) {\\\\\\\\\\\\\\\\n    return !SceneManager.areButtonsHidden();\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    return true;\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.updateButtonPositions();\\\\\\\\\\\\\\\\nthis.updateWindowPositions();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.updateButtonPositions();\\\\\\\\\\\\\\\\n    this.updateWindowPositions();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.ButtonPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHoverSelect\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"77\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Hover Select\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.hoverEnabled.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Menu Arrangement\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiMenuStyle\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Menu Style\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'Recommended';\\\\\\\\\\\\\\\\nconst on  = 'Custom';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiHelpPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Help Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '↑';\\\\\\\\\\\\\\\\nconst on  = '↓';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.HelpPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"uiInputPosition\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"244\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Input Window Position\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.uiMenuStyle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = '←';\\\\\\\\\\\\\\\\nconst on  = '→';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && !value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(ConfigManager.uiMenuStyle && value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = uiDefault.InputPosition.call(this);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle UI\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"provokeOrigin\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.provokeOrigin;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"aggroGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.aggroGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualHpGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"84\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualHpGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"visualAtbGauge\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.visualAtbGauge;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn BattleManager.isTpb() && Imported.VisuMZ_2_BattleSystemATB && VisuMZ.BattleSystemATB.Settings.Options.AddOption;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn (\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Provoke.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_2_AggroControlSystem && VisuMZ.AggroControlSystem.Settings.Aggro.AddOption) ||\\\\\\\\\\\\\\\\n    (BattleManager.isTpb() && Imported.VisuMZ_3_VisualAtbGauge && VisuMZ.VisualAtbGauge.Settings.Options.AddOption) ||\\\\\\\\\\\\\\\\n    (Imported.VisuMZ_1_BattleCore && VisuMZ.BattleCore.Settings.HpGauge.AddHpGaugeOption) ||\\\\\\\\\\\\\\\\n  false);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}","{\"Name:str\":\"Playtest\",\"Icon:num\":\"84\",\"ShowJS:func\":\"\\\"// Return Boolean\\\\nreturn $gameTemp.isPlaytest();\\\"\",\"List:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"87\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Playtest Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\\nthis.refresh();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n    this.refresh();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Exploration\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistMapSpeed\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"82\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Map Update Speed\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 4;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['Normal', 'Fast', 'Faster', 'Fastest'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 4; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 3 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 3);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 3);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 3);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistRandomEncounters\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"76\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Random Encounters\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst segment = halfWidth / 3;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Segments\\\\\\\\\\\\\\\\nconst speedText = ['None', 'Half', 'Normal'];\\\\\\\\\\\\\\\\nfor (let i = 0; i < 3; i++) {\\\\\\\\\\\\\\\\n    this.changePaintOpacity(i === value);\\\\\\\\\\\\\\\\n    const text = speedText[i];\\\\\\\\\\\\\\\\n    const sx = rect.x + halfWidth + (segment * i);\\\\\\\\\\\\\\\\n    this.drawText(text, sx, rect.y, segment, 'center');\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 2 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 2);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 2);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 2;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 2);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Battle\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGodmode\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"God Mode\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistResistNegatives\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Resist Negative Effects\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode && Imported.VisuMZ_1_SkillsStatesCore;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistInstantKO\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Instant K.O.\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = false;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSkillCosts\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Skill Costs\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistConsumeItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Consume Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Status Text\\\\\\\\\\\\\\\\nconst off = 'OFF';\\\\\\\\\\\\\\\\nconst on  = 'ON';\\\\\\\\\\\\\\\\nthis.changePaintOpacity(!value);\\\\\\\\\\\\\\\\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\nthis.changePaintOpacity(value);\\\\\\\\\\\\\\\\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, !value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nthis.playCursorSound();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, true);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, false);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (this.getConfigValue(symbol) !== lastValue) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol];\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol];\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Rewards\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistExpMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"88\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"EXP Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(30);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(31);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistGoldMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"314\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Gold Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(14);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(6);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistDropMultiplier\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Drop Multiplier\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Gauge\\\\\\\\\\\\\\\\nconst rate = (value / 10).clamp(0, 1);\\\\\\\\\\\\\\\\nconst gx = rect.x + halfWidth;\\\\\\\\\\\\\\\\nconst gy = rect.y + rect.height - 14;\\\\\\\\\\\\\\\\nconst fillW = Math.floor((halfWidth - 2) * rate);\\\\\\\\\\\\\\\\nconst color0 = ColorManager.gaugeBackColor();\\\\\\\\\\\\\\\\nconst color1 = ColorManager.textColor(11);\\\\\\\\\\\\\\\\nconst color2 = ColorManager.textColor(3);\\\\\\\\\\\\\\\\nthis.contents.fillRect(gx, gy, halfWidth, 12, color0);\\\\\\\\\\\\\\\\nthis.contents.gradientFillRect(gx + 1, gy + 1, fillW, 10, color1, color2);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Value\\\\\\\\\\\\\\\\nconst text = 'x%1'.format(2 ** value);\\\\\\\\\\\\\\\\nthis.drawText(text, rect.x + halfWidth, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nif (value >= 10 && (Input.isTriggered(\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\") || TouchInput.isClicked())) {\\\\\\\\\\\\\\\\n    value = 0;\\\\\\\\\\\\\\\\n} else {\\\\\\\\\\\\\\\\n    value += 1;\\\\\\\\\\\\\\\\n    value = value.clamp(0, 10);\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue += 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nlet value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\nconst lastValue = value;\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nvalue -= 1;\\\\\\\\\\\\\\\\nvalue = value.clamp(0, 10);\\\\\\\\\\\\\\\\nthis.setConfigValue(symbol, value);\\\\\\\\\\\\\\\\nthis.redrawItem(this.findSymbol(symbol));\\\\\\\\\\\\\\\\nif (lastValue !== value) {\\\\\\\\\\\\\\\\n    this.playCursorSound();\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Perform Actions\\\\\\\\\\\\\\\\nConfigManager[symbol] = 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nconfig[symbol] = ConfigManager[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst config = arguments[0];\\\\\\\\\\\\\\\\nconst symbol = arguments[1];\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Return Value\\\\\\\\\\\\\\\\nConfigManager[symbol] = config[symbol].clamp(0, 10);\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Spawners\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnItems\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"176\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Items\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataItems) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([0, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnWeapons\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"97\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Weapons\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataWeapons) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([1, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistSpawnArmors\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"137\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Spawn Armors\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Spawn Items\\\\\\\\\\\\\\\\nconst goods = [];\\\\\\\\\\\\\\\\nfor (const item of $dataArmors) {\\\\\\\\\\\\\\\\n    if (item && item.name.trim() !== '') {\\\\\\\\\\\\\\\\n        goods.push([2, item.id, 1, 0]);\\\\\\\\\\\\\\\\n    }\\\\\\\\\\\\\\\\n}\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Shop);\\\\\\\\\\\\\\\\nSceneManager.prepareNextScene(goods, true);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\\C[16]Debug\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"assistCallDebug\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"89\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Debug Menu\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Declare Constants\\\\\\\\\\\\\\\\nconst symbol = arguments[0];\\\\\\\\\\\\\\\\nconst index = arguments[1];\\\\\\\\\\\\\\\\nconst title = this.commandName(index);\\\\\\\\\\\\\\\\nconst rect = this.itemLineRect(index);\\\\\\\\\\\\\\\\nconst quarterWidth = rect.width / 4;\\\\\\\\\\\\\\\\nconst halfWidth = rect.width / 2;\\\\\\\\\\\\\\\\nconst value = this.getConfigValue(symbol);\\\\\\\\\\\\\\\\n\\\\\\\\\\\\\\\\n// Draw Command Name\\\\\\\\\\\\\\\\nthis.resetFontSettings();\\\\\\\\\\\\\\\\nthis.changePaintOpacity(true);\\\\\\\\\\\\\\\\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\");\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Call Debug Menu\\\\\\\\\\\\\\\\nSceneManager.push(Scene_Debug);\\\\\\\\\\\\\\\\nthis.prepareOptionsCoreSceneChange();\\\\\\\\\\\\\\\\nSoundManager.playOk();\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"-----------------------------\\\\\\\",\\\\\\\"Icon:num\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return 'Text';\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Accessibility\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn ConfigManager.assistMode;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Boolean\\\\\\\\\\\\\\\\nreturn true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Return Value\\\\\\\\\\\\\\\\nreturn 0;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Functions\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DrawJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ProcessOkJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorRightJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CursorLeftJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"Data\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DefaultJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"SaveJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"LoadJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"// Do Nothing\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\"}"]
 *
 * @param Rebind:struct
 * @text Keyboard/Controller Rebind
 * @type struct<Rebind>
 * @desc Settings that allow the player to rebind their keyboard
 * and controller inputs. Requires VisuMZ_0_CoreEngine!
 * @default {"General":"","EnableRebind:eval":"true","keyOrder:arraystr":"[\"up\",\"left\",\"down\",\"right\",\"ok\",\"escape\",\"shift\",\"tab\",\"pageup\",\"pagedown\"]","gamepadOrder:arraystr":"[\"up\",\"left\",\"down\",\"right\",\"ok\",\"cancel\",\"menu\",\"shift\",\"pageup\",\"pagedown\"]","gamepadReset:func":"\"Input.gamepadMapper = {\\n    0: \\\"ok\\\", // A\\n    1: \\\"cancel\\\", // B\\n    2: \\\"shift\\\", // X\\n    3: \\\"menu\\\", // Y\\n    4: \\\"pageup\\\", // LB\\n    5: \\\"pagedown\\\", // RB\\n    12: \\\"up\\\", // D-pad up\\n    13: \\\"down\\\", // D-pad down\\n    14: \\\"left\\\", // D-pad left\\n    15: \\\"right\\\" // D-pad right\\n};\"","Vocab":"","ButtonVocab":"","up:str":"Up","left:str":"Left","down:str":"Down","right:str":"Right","ok:str":"Confirm","escape:str":"Cancel & Menu","cancel:str":"Cancel","menu:str":"Menu","pageup:str":"Switch Left","pagedown:str":"Switch Right","shift:str":"Dash","tab:str":"Tab","buttonFmt:str":"\\}Button\\{ %1","dpadFmt:str":"\\}D-Pad\\{ %1","ButtonAssistVocab":"","removeAssist:str":"Remove","resetAssist:str":"Reset","confirmAssist:str":"Rebind","cancelAssist:str":"Exit","HelpVocab":"","selectKeyboard:json":"\"Select a key to rebind/change.\"","pressKeyboard:json":"\"Press a keyboard button to assign this control.\"","pressForbidden:json":"\"That key cannot be bound to a control.\"","selectGamepad:json":"\"Select a button to rebind/change.\"","pressGamepad:json":"\"Press a gamepad button to assign this control.\"","buttonForbidden:json":"\"This button cannot be reassigned.\"","noGamepadFound:json":"\"No gamepad is detected!\"","Windows":"","HelpWindow":"","HelpWindow_BgType:num":"0","RebindWindow":"","RebindWindow_BgType:num":"0","keyNameAlign:str":"center","rebindAlign:str":"center","RebindWindow_RectJS:func":"\"const buffer = 48;\\nconst ww = Math.ceil((Graphics.boxWidth - (buffer * 2)) * (this.isForGamepad() ? 2/3 : 1));\\nconst wh = this.mainAreaHeight() - (buffer * 2);\\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\\nconst wy = this.mainAreaTop() + Math.floor((this.mainAreaHeight() - wh) / 2);\\nreturn new Rectangle(wx, wy, ww, wh);\"","HelpRebindWindow":"","HelpRebindWindow_BgType:num":"0","HelpRebindWindow_RectJS:func":"\"const ww = Math.ceil(Graphics.boxWidth * 2/3);\\nconst wh = this.calcWindowHeight(2, false);\\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\\nconst wy = Math.floor((Graphics.boxHeight - wh) / 2);\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 *
 * @param ControllerButtons:arraystruct
 * @text Controller Buttons
 * @parent Rebind:struct
 * @type struct<ControllerButtons>[]
 * @desc Make different icons appear for different controllers.
 * Requires VisuMZ_0_CoreEngine!
 * @default []
 *
 * @param MasterVolShortcut:struct
 * @text Master Volume Shortcut
 * @type struct<MasterVolShortcut>
 * @desc Settings regarding the Master Volume Shortcut keys.
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default {"Shortcut":"","Enable:eval":"true","change:num":"10","Sfx":"","VolUpSfx":"","upName:str":"Up1","upVolume:num":"90","upPitch:num":"100","upPan:num":"0","VolDnSfx":"","downName:str":"Down1","downVolume:num":"90","downPitch:num":"100","downPan:num":"0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Categories List
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param Name:str
 * @text Name
 * @desc The name of this category as seen in the Category Window.
 * Text codes are supported.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @parent Name:str
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Name:str
 * @type note
 * @desc Code used to determine if this category is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param List:arraystruct
 * @text Options List
 * @type struct<Options>[]
 * @desc Add options to this category here.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Options List
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Symbol:str
 * @text Symbol
 * @desc Symbol used for this option when selected.
 * Make sure this is unique from other symbols.
 * @default Symbol
 *
 * @param Icon:num
 * @text Icon
 * @parent Symbol:str
 * @desc Icon used for this option.
 * Use 0 for no icon.
 * @default 0
 *
 * @param TextStr:str
 * @text STR: Text
 * @parent Symbol:str
 * @desc Displayed text used for this option.
 * If this has a value, ignore the JS: Text version.
 * @default Untitled
 *
 * @param TextJS:func
 * @text JS: Text
 * @parent Symbol:str
 * @type note
 * @desc JavaScript code used to determine string used for the displayed name.
 * @default "return 'Text';"
 *
 * @param Accessibility
 *
 * @param ShowJS:func
 * @text JS: Show/Hide
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is visible.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option is enabled.
 * @default "// Return Boolean\nreturn true;"
 *
 * @param ExtJS:func
 * @text JS: Ext
 * @parent Accessibility
 * @type note
 * @desc Code used to determine if this option's ext value.
 * @default "// Return Value\nreturn 0;"
 *
 * @param Functions
 *
 * @param DrawJS:func
 * @text JS: Draw Option
 * @parent Functions
 * @type note
 * @desc Code used to draw this item into the List Window.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst index = arguments[1];\nconst title = this.commandName(index);\nconst rect = this.itemLineRect(index);\nconst quarterWidth = rect.width / 4;\nconst halfWidth = rect.width / 2;\nconst value = this.getConfigValue(symbol);\n\n// Draw Command Name\nthis.resetFontSettings();\nthis.changePaintOpacity(true);\nthis.drawTextEx(title, rect.x, rect.y, halfWidth, \"left\");\n\n// Draw Status Text\nconst off = 'OFF';\nconst on  = 'ON';\nthis.changePaintOpacity(!value);\nthis.drawText(off, rect.x + halfWidth, rect.y, quarterWidth, \"center\");\nthis.changePaintOpacity(value);\nthis.drawText(on, rect.x + halfWidth + quarterWidth, rect.y, quarterWidth, \"center\");"
 *
 * @param ProcessOkJS:func
 * @text JS: Process OK
 * @parent Functions
 * @type note
 * @desc Code used when OK button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\n\n// Perform Actions\nthis.setConfigValue(symbol, !value);\nthis.redrawItem(this.findSymbol(symbol));\nthis.playCursorSound();"
 *
 * @param CursorRightJS:func
 * @text JS: Cursor Right
 * @parent Functions
 * @type note
 * @desc Code used when Right button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, true);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param CursorLeftJS:func
 * @text JS: Cursor Left
 * @parent Functions
 * @type note
 * @desc Code used when Left button is pressed while selected.
 * @default "// Declare Constants\nconst symbol = arguments[0];\nconst value = this.getConfigValue(symbol);\nconst lastValue = value;\n\n// Perform Actions\nthis.setConfigValue(symbol, false);\nthis.redrawItem(this.findSymbol(symbol));\nif (this.getConfigValue(symbol) !== lastValue) {\n    this.playCursorSound();\n}"
 *
 * @param Data
 *
 * @param DefaultJS:func
 * @text JS: Default Value
 * @parent Data
 * @type note
 * @desc Code used to determine the default value of this option.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Perform Actions\nConfigManager[symbol] = false;"
 *
 * @param SaveJS:func
 * @text JS: Save Option
 * @parent Data
 * @type note
 * @desc Code used when saving this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nconfig[symbol] = ConfigManager[symbol];"
 *
 * @param LoadJS:func
 * @text JS: Load Option
 * @parent Data
 * @type note
 * @desc Code used when loading this options setting.
 * @default "// Declare Constants\nconst config = arguments[0];\nconst symbol = arguments[1];\n\n// Return Value\nConfigManager[symbol] = config[symbol];"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OptionsSettings:
 *
 * @param Categories
 *
 * @param CategoryStyle:str
 * @text Category Window Style
 * @parent Categories
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Category Window?
 * @default auto
 *
 * @param CategoryTextAlign:str
 * @text Category Text Align
 * @parent Categories
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param categoryWindowBgType:num
 * @text Background Type
 * @parent Categories
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param OptionsWindow
 * @text Options Window
 *
 * @param optionsWindowBgType:num
 * @text Background Type
 * @parent OptionsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 * @param buttonAssistBgType:num
 * @text Background Type
 * @parent ButtonAssist
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * Requires VisuMZ_0_CoreEngine!
 * @default 0
 *
 * @param Sound
 *
 * @param SFXCursorList:arraystr
 * @text Cursor Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cursor SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXOKList:arraystr
 * @text OK Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for OK SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXCancelList:arraystr
 * @text Cancel Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for cancel SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param SFXBuzzerList:arraystr
 * @text Buzzer Sounds
 * @parent Sound
 * @type file[]
 * @dir audio/se/
 * @desc SE files player can select from for buzzer SE.
 * The first in the list will always be the default SE.
 * @default ["Default"]
 *
 * @param Text
 *
 * @param FontFaces:arraystr
 * @text Font Options
 * @parent Text
 * @type string[]
 * @desc Available fonts for the player to select from.
 * The first font in the list is always be the default font.
 * @default ["Default","Arial","Verdana","Times New Roman"]
 *
 */
/* ----------------------------------------------------------------------------
 * Rebind Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Rebind:
 *
 * @param General
 * @text General Settings
 *
 * @param EnableRebind:eval
 * @text Enable Rebinding?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable keyboard and controller rebinding?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 *
 * @param keyOrder:arraystr
 * @text Keyboard Bindings
 * @parent General
 * @type select[]
 * @option up
 * @option left
 * @option down
 * @option right
 * @option ok
 * @option escape
 * @option cancel
 * @option menu
 * @option shift
 * @option tab
 * @option pageup
 * @option pagedown
 * @desc Select the keys that can be rebound and the order they appear for keyboard.
 * @default ["up","left","down","right","ok","escape","shift","tab","pageup","pagedown"]
 *
 * @param gamepadOrder:arraystr
 * @text Gamepad Bindings
 * @parent General
 * @type select[]
 * @option up
 * @option left
 * @option down
 * @option right
 * @option ok
 * @option escape
 * @option cancel
 * @option menu
 * @option shift
 * @option tab
 * @option pageup
 * @option pagedown
 * @desc Select the keys that can be rebound and the order they appear for gamepad.
 * @default ["up","left","down","right","ok","cancel","menu","shift","pageup","pagedown"]
 *
 * @param gamepadReset:func
 * @text JS: Reset Gamepad
 * @parent gamepadOrder:arraystr
 * @type note
 * @desc Determine how the gamepad map should be when reset.
 * @default "Input.gamepadMapper = {\n    0: \"ok\", // A\n    1: \"cancel\", // B\n    2: \"shift\", // X\n    3: \"menu\", // Y\n    4: \"pageup\", // LB\n    5: \"pagedown\", // RB\n    12: \"up\", // D-pad up\n    13: \"down\", // D-pad down\n    14: \"left\", // D-pad left\n    15: \"right\" // D-pad right\n};"
 *
 * @param Vocab
 * @text Vocabulary
 *
 * @param ButtonVocab
 * @text Button Vocab
 * @parent Vocab
 *
 * @param up:str
 * @text Up
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Up
 *
 * @param left:str
 * @text Left
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Left
 *
 * @param down:str
 * @text Down
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Down
 *
 * @param right:str
 * @text Right
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Right
 *
 * @param ok:str
 * @text OK
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Confirm
 *
 * @param escape:str
 * @text Escape
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Cancel & Menu
 *
 * @param cancel:str
 * @text Cancel
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Cancel
 *
 * @param menu:str
 * @text Menu
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Menu
 *
 * @param pageup:str
 * @text Page Up
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Switch Left
 *
 * @param pagedown:str
 * @text Page Down
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Switch Right
 *
 * @param shift:str
 * @text Shift
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Dash
 *
 * @param tab:str
 * @text Tab
 * @parent ButtonVocab
 * @desc Text used to represent this input type.
 * Text codes allowed.
 * @default Tab
 *
 * @param buttonFmt:str
 * @text Button Format
 * @parent ButtonVocab
 * @desc Text format for unassigned gamepad buttons.
 * Text codes allowed. %1 - Button ID.
 * @default \}Button\{ %1
 *
 * @param dpadFmt:str
 * @text D-Pad Format
 * @parent ButtonVocab
 * @desc Text format for directional pad buttons.
 * Text codes allowed. %1 - Direction.
 * @default \}D-Pad\{ %1
 *
 * @param ButtonAssistVocab
 * @text Button Assist
 * @parent Vocab
 *
 * @param removeAssist:str
 * @text Shift: Remove
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Remove
 *
 * @param resetAssist:str
 * @text Shift: Reset
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Reset
 *
 * @param confirmAssist:str
 * @text OK: Select
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Rebind
 *
 * @param cancelAssist:str
 * @text Cancel: Exit
 * @parent ButtonAssistVocab
 * @desc Text used to represent this button assist.
 * @default Exit
 *
 * @param HelpVocab
 * @text Help Descriptions
 * @parent Vocab
 *
 * @param selectKeyboard:json
 * @text Select for Keyboard
 * @parent HelpVocab
 * @type note
 * @desc Help description used for selecting a keyboard button.
 * Text codes allowed.
 * @default "Select a key to rebind/change."
 *
 * @param pressKeyboard:json
 * @text Keyboard Instruct
 * @parent HelpVocab
 * @type note
 * @desc Help description used to ask for a key to press.
 * Text codes allowed.
 * @default "Press a keyboard button to assign this control."
 *
 * @param pressForbidden:json
 * @text Forbidden Key
 * @parent HelpVocab
 * @type note
 * @desc Help description used when a keyboard key cannot be used.
 * Text codes allowed.
 * @default "That key cannot be bound to a control."
 *
 * @param selectGamepad:json
 * @text Select for Gamepad
 * @parent HelpVocab
 * @type note
 * @desc Help description used for selecting a gamepad button.
 * Text codes allowed.
 * @default "Select a button to rebind/change."
 *
 * @param pressGamepad:json
 * @text Gamepad Instructions
 * @parent HelpVocab
 * @type note
 * @desc Help description used to ask for a gamepad button to press.
 * Text codes allowed.
 * @default "Press a gamepad button to assign this control."
 *
 * @param buttonForbidden:json
 * @text Forbidden Button
 * @parent HelpVocab
 * @type note
 * @desc Help description used when a gamepad button cannot be reassigned.
 * Text codes allowed.
 * @default "This button cannot be reassigned."
 *
 * @param noGamepadFound:json
 * @text No Gamepad Detected
 * @parent HelpVocab
 * @type note
 * @desc Help description used when no gamepad is detected.
 * Text codes allowed.
 * @default "No gamepad is detected!"
 *
 * @param Windows
 * @text Window Settings
 *
 * @param HelpWindow
 * @text Window_Help
 * @parent Windows
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param RebindWindow
 * @text Window_KeyRebinds
 * @parent Windows
 *
 * @param RebindWindow_BgType:num
 * @text Background Type
 * @parent RebindWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param keyNameAlign:str
 * @text Key Type Align
 * @parent RebindWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the key types?
 * @default center
 *
 * @param rebindAlign:str
 * @text Rebind Key Align
 * @parent RebindWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the rebind key?
 * @default center
 *
 * @param RebindWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent RebindWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const buffer = 48;\nconst ww = Math.ceil((Graphics.boxWidth - (buffer * 2)) * (this.isForGamepad() ? 2/3 : 1));\nconst wh = this.mainAreaHeight() - (buffer * 2);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = this.mainAreaTop() + Math.floor((this.mainAreaHeight() - wh) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param HelpRebindWindow
 * @text Window_RebindHelp
 * @parent Windows
 *
 * @param HelpRebindWindow_BgType:num
 * @text Background Type
 * @parent HelpRebindWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRebindWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpRebindWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.boxWidth * 2/3);\nconst wh = this.calcWindowHeight(2, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = Math.floor((Graphics.boxHeight - wh) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Controller Buttons Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ControllerButtons:
 *
 * @param ID
 * @text ID Information
 *
 * @param Name:str
 * @text Controller ID Name
 * @parent ID
 * @desc Exact string used for this controller ID.
 * User VisuMZ_0_CoreEngine plugin commands for help.
 * @default Untitled
 *
 * @param Match:str
 * @text Similarity Match
 * @parent ID
 * @desc Similar text used for this controller ID.
 * User VisuMZ_0_CoreEngine plugin commands for help.
 * @default Untitled
 * 
 * @param Buttons
 * @text Button Text
 *
 * @param button0:str
 * @text Button 0
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 0
 *
 * @param button1:str
 * @text Button 1
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 1
 *
 * @param button2:str
 * @text Button 2
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 2
 *
 * @param button3:str
 * @text Button 3
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 3
 *
 * @param button4:str
 * @text Button 4
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 4
 *
 * @param button5:str
 * @text Button 5
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 5
 *
 * @param button6:str
 * @text Button 6
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 6
 *
 * @param button7:str
 * @text Button 7
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 7
 *
 * @param button8:str
 * @text Button 8
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 8
 *
 * @param button9:str
 * @text Button 9
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 9
 *
 * @param button10:str
 * @text Button 10
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 10
 *
 * @param button11:str
 * @text Button 11
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 11
 *
 * @param button12:str
 * @text Button 12
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Up
 *
 * @param button13:str
 * @text Button 13
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Down
 *
 * @param button14:str
 * @text Button 14
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Left
 *
 * @param button15:str
 * @text Button 15
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}D-Pad\{ Right
 *
 * @param button16:str
 * @text Button 16
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 16
 *
 * @param button17:str
 * @text Button 17
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 17
 *
 * @param button18:str
 * @text Button 18
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 18
 *
 * @param button19:str
 * @text Button 19
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 19
 *
 * @param button20:str
 * @text Button 20
 * @parent Buttons
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default \}Button\{ 20
 * 
*/
/* ----------------------------------------------------------------------------
 * Master Volume Shortcut Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MasterVolShortcut:
 * 
 * @param Shortcut
 *
 * @param Enable:eval
 * @text Enabled?
 * @parent Shortcut
 * @type boolean
 * @on Enable Shortcut
 * @off Disable Shortcut
 * @desc Enable the shortcut?
 * Shortcut: Ctrl + PageUp / Ctrl + PageDn
 * @default true
 *
 * @param change:num
 * @text Shortcut Change Value
 * @parent Shortcut
 * @type number
 * @min 1
 * @max 100
 * @desc What is the change amount for the shortcut key?
 * Master volume caps at 0 and 100.
 * @default 10
 * 
 * @param Sfx
 * @text Sound Effects
 * 
 * @param VolUpSfx
 * @text Volume Up
 * @parent Sfx
 *
 * @param upName:str
 * @text Filename
 * @parent VolUpSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Up1
 *
 * @param upVolume:num
 * @text Volume
 * @parent VolUpSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param upPitch:num
 * @text Pitch
 * @parent VolUpSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param upPan:num
 * @text Pan
 * @parent VolUpSfx
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param VolDnSfx
 * @text Volume Down
 * @parent Sfx
 *
 * @param downName:str
 * @text Filename
 * @parent VolDnSfx
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Down1
 *
 * @param downVolume:num
 * @text Volume
 * @parent VolDnSfx
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param downPitch:num
 * @text Pitch
 * @parent VolDnSfx
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param downPan:num
 * @text Pan
 * @parent VolDnSfx
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0x3fa3c2=_0x36d3;(function(_0x4a94b7,_0x53c19a){const _0x4a54cd=_0x36d3,_0x3e2f82=_0x4a94b7();while(!![]){try{const _0x20be9d=parseInt(_0x4a54cd(0x297))/0x1*(parseInt(_0x4a54cd(0x20b))/0x2)+-parseInt(_0x4a54cd(0x26a))/0x3*(-parseInt(_0x4a54cd(0x151))/0x4)+-parseInt(_0x4a54cd(0x20f))/0x5*(parseInt(_0x4a54cd(0x1ee))/0x6)+parseInt(_0x4a54cd(0x1db))/0x7*(parseInt(_0x4a54cd(0x12a))/0x8)+-parseInt(_0x4a54cd(0x1c6))/0x9+parseInt(_0x4a54cd(0x1e6))/0xa*(-parseInt(_0x4a54cd(0x1d6))/0xb)+parseInt(_0x4a54cd(0x29b))/0xc;if(_0x20be9d===_0x53c19a)break;else _0x3e2f82['push'](_0x3e2f82['shift']());}catch(_0x256ac6){_0x3e2f82['push'](_0x3e2f82['shift']());}}}(_0x10d2,0xbb315));var label=_0x3fa3c2(0x12c),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x3fa3c2(0x15a)](function(_0x2821c9){const _0x598276=_0x3fa3c2;return _0x2821c9[_0x598276(0x2ec)]&&_0x2821c9['description'][_0x598276(0x26f)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x3fa3c2(0x237)]||{},VisuMZ[_0x3fa3c2(0x122)]=function(_0x1bcbdb,_0x14c429){const _0xbdc1f4=_0x3fa3c2;for(const _0xda2048 in _0x14c429){if(_0xda2048['match'](/(.*):(.*)/i)){const _0x4d2170=String(RegExp['$1']),_0x1c573d=String(RegExp['$2'])[_0xbdc1f4(0x123)]()[_0xbdc1f4(0x311)]();let _0x65d7e1,_0x3dc265,_0x35c538;switch(_0x1c573d){case _0xbdc1f4(0x2fe):_0x65d7e1=_0x14c429[_0xda2048]!==''?Number(_0x14c429[_0xda2048]):0x0;break;case'ARRAYNUM':_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265['map'](_0x17ab32=>Number(_0x17ab32));break;case _0xbdc1f4(0x1ce):_0x65d7e1=_0x14c429[_0xda2048]!==''?eval(_0x14c429[_0xda2048]):null;break;case _0xbdc1f4(0x16c):_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265[_0xbdc1f4(0x265)](_0x4085a7=>eval(_0x4085a7));break;case _0xbdc1f4(0x1d5):_0x65d7e1=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):'';break;case _0xbdc1f4(0x22b):_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265[_0xbdc1f4(0x265)](_0x44a591=>JSON[_0xbdc1f4(0x1c0)](_0x44a591));break;case _0xbdc1f4(0x2ff):_0x65d7e1=_0x14c429[_0xda2048]!==''?new Function(JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048])):new Function(_0xbdc1f4(0x231));break;case _0xbdc1f4(0x208):_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265[_0xbdc1f4(0x265)](_0x5ddeaa=>new Function(JSON[_0xbdc1f4(0x1c0)](_0x5ddeaa)));break;case'STR':_0x65d7e1=_0x14c429[_0xda2048]!==''?String(_0x14c429[_0xda2048]):'';break;case _0xbdc1f4(0x12d):_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265[_0xbdc1f4(0x265)](_0xbea843=>String(_0xbea843));break;case'STRUCT':_0x35c538=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):{},_0x1bcbdb[_0x4d2170]={},VisuMZ[_0xbdc1f4(0x122)](_0x1bcbdb[_0x4d2170],_0x35c538);continue;case'ARRAYSTRUCT':_0x3dc265=_0x14c429[_0xda2048]!==''?JSON[_0xbdc1f4(0x1c0)](_0x14c429[_0xda2048]):[],_0x65d7e1=_0x3dc265[_0xbdc1f4(0x265)](_0xc850e9=>VisuMZ[_0xbdc1f4(0x122)]({},JSON[_0xbdc1f4(0x1c0)](_0xc850e9)));break;default:continue;}_0x1bcbdb[_0x4d2170]=_0x65d7e1;}}return _0x1bcbdb;},(_0x2b29a5=>{const _0xccad25=_0x3fa3c2,_0x36549d=_0x2b29a5['name'];for(const _0x2bd696 of dependencies){if(!Imported[_0x2bd696]){alert(_0xccad25(0x289)['format'](_0x36549d,_0x2bd696)),SceneManager[_0xccad25(0x2c6)]();break;}}const _0x4cce86=_0x2b29a5[_0xccad25(0x162)];if(_0x4cce86[_0xccad25(0x2e2)](/\[Version[ ](.*?)\]/i)){const _0x583ccd=Number(RegExp['$1']);_0x583ccd!==VisuMZ[label][_0xccad25(0x293)]&&(alert(_0xccad25(0x28b)[_0xccad25(0x2c5)](_0x36549d,_0x583ccd)),SceneManager[_0xccad25(0x2c6)]());}if(_0x4cce86['match'](/\[Tier[ ](\d+)\]/i)){const _0x49a953=Number(RegExp['$1']);_0x49a953<tier?(alert(_0xccad25(0x171)['format'](_0x36549d,_0x49a953,tier)),SceneManager[_0xccad25(0x2c6)]()):tier=Math[_0xccad25(0xfc)](_0x49a953,tier);}VisuMZ[_0xccad25(0x122)](VisuMZ[label]['Settings'],_0x2b29a5[_0xccad25(0x2a7)]);})(pluginData),VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x1af)]=Scene_Boot[_0x3fa3c2(0x16e)][_0x3fa3c2(0x220)],Scene_Boot['prototype'][_0x3fa3c2(0x220)]=function(){const _0x362b69=_0x3fa3c2;this['process_VisuMZ_OptionsCore_DefaultLoad'](),VisuMZ[_0x362b69(0x12c)][_0x362b69(0x1af)]['call'](this),VisuMZ[_0x362b69(0x12c)][_0x362b69(0x1be)](),SoundManager[_0x362b69(0x14b)](),this[_0x362b69(0x29e)](),this[_0x362b69(0xf3)](),!Utils['isOptionValid']('test')&&(ConfigManager[_0x362b69(0x199)]=![]);},VisuMZ['OptionsCore']['CheckCompatibility']=function(){const _0x469e68=_0x3fa3c2;if(Imported['VisuMZ_0_CoreEngine']&&VisuMZ[_0x469e68(0x2bf)][_0x469e68(0x293)]<1.64){let _0x2c253c='';_0x2c253c+=_0x469e68(0x1dc),_0x2c253c+=_0x469e68(0x1a1),alert(_0x2c253c),SceneManager[_0x469e68(0x2c6)]();}if(Imported['VisuMZ_3_ButtonTriggerEvts']&&VisuMZ[_0x469e68(0x238)]['version']<1.05){let _0x4b534a='';_0x4b534a+=_0x469e68(0x1ff),_0x4b534a+=_0x469e68(0x1a1),alert(_0x4b534a),SceneManager[_0x469e68(0x2c6)]();}if(Imported['VisuMZ_4_ButtonCmnEvts']&&VisuMZ[_0x469e68(0x290)]['version']<1.09){let _0x410ebc='';_0x410ebc+=_0x469e68(0x13f),_0x410ebc+=_0x469e68(0x1a1),alert(_0x410ebc),SceneManager[_0x469e68(0x2c6)]();}},Scene_Boot['prototype'][_0x3fa3c2(0x152)]=function(){const _0x1b4aaa=_0x3fa3c2,_0x5975b9=[_0x1b4aaa(0x1e9),_0x1b4aaa(0x2ee),'touchUI',_0x1b4aaa(0x281),_0x1b4aaa(0x17e),_0x1b4aaa(0x126),'seVolume'];for(const _0x2930e2 of VisuMZ[_0x1b4aaa(0x12c)][_0x1b4aaa(0x237)][_0x1b4aaa(0x2be)]){for(const _0x260a4e of _0x2930e2[_0x1b4aaa(0x294)]){if(!_0x260a4e)continue;const _0x3d51b2=_0x260a4e['Symbol'];if(!_0x3d51b2)continue;if(_0x5975b9['includes'](_0x3d51b2))ConfigManager[_0x3d51b2]=undefined;_0x260a4e[_0x1b4aaa(0x29f)]['call'](this,ConfigManager,_0x3d51b2);}}},Scene_Boot[_0x3fa3c2(0x16e)][_0x3fa3c2(0x29e)]=function(){const _0x3b159c=_0x3fa3c2;if(VisuMZ[_0x3b159c(0x12c)][_0x3b159c(0x271)]())return;const _0x34af6e=_0x3b159c(0x182),_0xa91674=[0x3,0x8,0x5,0x1,0x14,0x13],_0x549a63=_0xa91674[_0x3b159c(0x283)]((_0x235d22,_0x1fddcb)=>_0x235d22+_0x34af6e[_0x1fddcb],''),_0x3cbc29={'Name:str':_0x549a63,'Icon:num':'7','ShowJS:func':_0x3b159c(0x165),'List:arraystruct':_0x3b159c(0x1aa)};Window_OptionsCategory[_0x3b159c(0x2d0)][_0x3b159c(0x30b)](VisuMZ['ConvertParams'](_0x3cbc29,_0x3cbc29));},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x271)]=function(){const _0xf46bf5=_0x3fa3c2,_0x5e2564=_0xf46bf5(0x182),_0x50f5f5=[0x1,0x13,0x13,0x9,0x13,0x14,0xd,0xf,0x4,0x5],_0x5cd06d=_0x50f5f5['reduce']((_0x246507,_0x406f26)=>_0x246507+_0x5e2564[_0x406f26],'');for(const _0x75b585 of Window_OptionsCategory[_0xf46bf5(0x2d0)]){if(!_0x75b585)continue;for(const _0x3959c0 of _0x75b585[_0xf46bf5(0x294)]){if(!_0x3959c0)continue;if(_0x3959c0[_0xf46bf5(0x1bf)][_0xf46bf5(0x269)]()['trim']()===_0x5cd06d)return!![];}}return![];},VisuMZ[_0x3fa3c2(0x12c)]['ControllerButtons']={},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x145)]={},Scene_Boot['prototype']['process_VisuMZ_OptionsCore_ControllerButtons']=function(){const _0x174885=_0x3fa3c2,_0x54e09b=VisuMZ['OptionsCore'][_0x174885(0x237)][_0x174885(0x1eb)];for(const _0x47be8a of _0x54e09b){const _0xb6779a=(_0x47be8a[_0x174885(0x133)]||'')['toLowerCase']()[_0x174885(0x311)](),_0x1dc7c9=(_0x47be8a['Match']||'')['toLowerCase']()['trim']();VisuMZ['OptionsCore'][_0x174885(0x1eb)][_0xb6779a]=_0x47be8a,VisuMZ['OptionsCore'][_0x174885(0x145)][_0x1dc7c9]=_0xb6779a;}},VisuMZ[_0x3fa3c2(0x12c)]['ConfigManager_save']=ConfigManager[_0x3fa3c2(0x1f5)],ConfigManager[_0x3fa3c2(0x1f5)]=function(){const _0x47e8be=_0x3fa3c2;if(this[_0x47e8be(0x233)]||this['_loading'])return;VisuMZ['OptionsCore'][_0x47e8be(0x1e7)][_0x47e8be(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)]['ConfigManager_makeData']=ConfigManager[_0x3fa3c2(0x282)],ConfigManager[_0x3fa3c2(0x282)]=function(){const _0x541c6f=_0x3fa3c2;let _0x5b1dca=VisuMZ[_0x541c6f(0x12c)][_0x541c6f(0x10e)]['call'](this);;try{_0x5b1dca=this['makeDataOptionsCore'](_0x5b1dca),_0x5b1dca=this['makeRebindSave'](_0x5b1dca);}catch(_0x2ea503){}return!Utils[_0x541c6f(0x1b6)](_0x541c6f(0x306))&&(_0x5b1dca['assistMode']=![]),_0x5b1dca;},ConfigManager['makeDataOptionsCore']=function(_0x23d9fb){const _0x5476a5=_0x3fa3c2;this[_0x5476a5(0x233)]=!![];for(const _0x4af75b of Window_OptionsCategory['categoryList']){for(const _0x20689f of _0x4af75b[_0x5476a5(0x294)]){if(!_0x20689f)continue;const _0x1869bf=_0x20689f[_0x5476a5(0x1bf)];if(!_0x1869bf)continue;ConfigManager[_0x1869bf]===undefined&&_0x20689f[_0x5476a5(0x29f)][_0x5476a5(0x206)](this,_0x23d9fb,_0x1869bf),_0x20689f[_0x5476a5(0x1f7)]['call'](this,_0x23d9fb,_0x1869bf);}}return this['_saving']=![],_0x23d9fb;},ConfigManager[_0x3fa3c2(0x11c)]=function(_0x3e917a){const _0x57dd06=_0x3fa3c2;if(!Scene_Options[_0x57dd06(0x1a3)])return _0x3e917a;return _0x3e917a['keyMapper']=Input['keyMapper'],_0x3e917a[_0x57dd06(0x2ad)]=Input[_0x57dd06(0x2ad)],_0x3e917a;},VisuMZ[_0x3fa3c2(0x12c)]['ConfigManager_applyData']=ConfigManager['applyData'],ConfigManager[_0x3fa3c2(0x100)]=function(_0x4fc4b8){const _0x21883c=_0x3fa3c2;VisuMZ[_0x21883c(0x12c)][_0x21883c(0x24b)]['call'](this,_0x4fc4b8),this[_0x21883c(0x279)](_0x4fc4b8),this[_0x21883c(0x2ea)](_0x4fc4b8);},ConfigManager[_0x3fa3c2(0x279)]=function(_0x4f3dca){const _0x3b41f1=_0x3fa3c2;this[_0x3b41f1(0x2f5)]=!![];for(const _0x448a91 of Window_OptionsCategory[_0x3b41f1(0x2d0)]){for(const _0x1fb0f9 of _0x448a91[_0x3b41f1(0x294)]){if(!_0x1fb0f9)continue;const _0x1e8741=_0x1fb0f9[_0x3b41f1(0x1bf)];if(!_0x1e8741)continue;_0x4f3dca[_0x1e8741]===undefined?_0x1fb0f9[_0x3b41f1(0x29f)][_0x3b41f1(0x206)](this,_0x4f3dca,_0x1e8741):_0x1fb0f9[_0x3b41f1(0x153)]['call'](this,_0x4f3dca,_0x1e8741);}}this['_loading']=![];},ConfigManager[_0x3fa3c2(0x2ea)]=function(_0x1ed608){const _0x327a0e=_0x3fa3c2;_0x1ed608['keyMapper']&&(Input[_0x327a0e(0x173)]=_0x1ed608['keyMapper']),_0x1ed608[_0x327a0e(0x2ad)]&&(Input[_0x327a0e(0x2ad)]=_0x1ed608['gamepadMapper']);},Graphics['_isFPSCounterOn']=function(){const _0x8217b2=_0x3fa3c2;return this['_fpsCounter']&&this[_0x8217b2(0x109)][_0x8217b2(0x140)]['style'][_0x8217b2(0x164)]!==_0x8217b2(0x1f6);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x134)]=Graphics['FPSCounter'][_0x3fa3c2(0x16e)][_0x3fa3c2(0x2c9)],Graphics[_0x3fa3c2(0x2af)][_0x3fa3c2(0x16e)][_0x3fa3c2(0x2c9)]=function(){const _0x459fc4=_0x3fa3c2;VisuMZ[_0x459fc4(0x12c)][_0x459fc4(0x134)][_0x459fc4(0x206)](this),this[_0x459fc4(0x19f)]();},Graphics['FPSCounter'][_0x3fa3c2(0x16e)]['switchModeOptionsCore']=function(){const _0x16cdc9=_0x3fa3c2;ConfigManager&&ConfigManager[_0x16cdc9(0x241)]!==undefined&&(ConfigManager[_0x16cdc9(0x241)]=Graphics[_0x16cdc9(0x166)](),ConfigManager[_0x16cdc9(0x1f5)]());if(SceneManager&&SceneManager['_scene']){const _0x42d3ca=SceneManager[_0x16cdc9(0x212)];_0x42d3ca[_0x16cdc9(0x26c)](),_0x42d3ca[_0x16cdc9(0x2ce)]===Scene_Options&&_0x42d3ca['refreshWindows']();}},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x301)]=Scene_Boot[_0x3fa3c2(0x16e)][_0x3fa3c2(0x221)],Scene_Boot[_0x3fa3c2(0x16e)][_0x3fa3c2(0x221)]=function(){const _0x2c3062=_0x3fa3c2;VisuMZ[_0x2c3062(0x12c)][_0x2c3062(0x301)]['call'](this),ConfigManager&&ConfigManager['fullScreen']&&Graphics[_0x2c3062(0x15d)]();},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2f3)]=Graphics[_0x3fa3c2(0x2c7)],Graphics[_0x3fa3c2(0x2c7)]=function(){const _0xe724cc=_0x3fa3c2;this['_isFullScreen']()?ConfigManager[_0xe724cc(0x1b9)]=![]:ConfigManager['fullScreen']=!![],ConfigManager[_0xe724cc(0x1f5)](),VisuMZ[_0xe724cc(0x12c)][_0xe724cc(0x2f3)]['call'](this),Graphics[_0xe724cc(0x15f)]();},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x200)]=Graphics[_0x3fa3c2(0x15d)],Graphics[_0x3fa3c2(0x15d)]=function(){const _0x4568d0=_0x3fa3c2;VisuMZ[_0x4568d0(0x12c)]['Graphics_requestFullScreen'][_0x4568d0(0x206)](this),this[_0x4568d0(0x15f)]();},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2b7)]=Graphics['_cancelFullScreen'],Graphics['_cancelFullScreen']=function(){const _0x55cba1=_0x3fa3c2;VisuMZ[_0x55cba1(0x12c)][_0x55cba1(0x2b7)][_0x55cba1(0x206)](this),this['_fullScreenOptionsCore']();},Graphics[_0x3fa3c2(0x15f)]=function(){const _0x5f18bf=_0x3fa3c2;if(SceneManager&&SceneManager[_0x5f18bf(0x212)]){const _0x523a3d=SceneManager['_scene'];_0x523a3d['constructor']===Scene_Options&&setTimeout(_0x523a3d[_0x5f18bf(0x20e)][_0x5f18bf(0x155)](_0x523a3d),0x64);}},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x183)]=Graphics[_0x3fa3c2(0x113)],Graphics[_0x3fa3c2(0x113)]=function(){const _0x5d88f5=_0x3fa3c2;VisuMZ[_0x5d88f5(0x12c)][_0x5d88f5(0x183)][_0x5d88f5(0x206)](this),this[_0x5d88f5(0x2a8)]();},Graphics[_0x3fa3c2(0x2a8)]=function(){const _0x46eb9e=_0x3fa3c2;ConfigManager&&ConfigManager['stretchScreen']!==undefined&&(ConfigManager[_0x46eb9e(0x1a9)]=!!this[_0x46eb9e(0x1e2)],setTimeout(ConfigManager[_0x46eb9e(0x1f5)]['bind'](ConfigManager),0x64));if(SceneManager&&SceneManager[_0x46eb9e(0x212)]){const _0x2b2bd6=SceneManager[_0x46eb9e(0x212)];_0x2b2bd6[_0x46eb9e(0x2ce)]===Scene_Options&&setTimeout(_0x2b2bd6['refreshWindows'][_0x46eb9e(0x155)](_0x2b2bd6),0x64);}},VisuMZ[_0x3fa3c2(0x12c)]['VolumeShortcut']={'enabled':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x16d)]['Enable']??!![],'change':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x16d)][_0x3fa3c2(0x28d)]??!![]},VisuMZ['OptionsCore'][_0x3fa3c2(0x2d4)]=Input['isTriggered'],Input[_0x3fa3c2(0x1fc)]=function(_0x2aa85c){const _0x2e7e69=_0x3fa3c2;if(VisuMZ[_0x2e7e69(0x12c)][_0x2e7e69(0x136)](_0x2aa85c,![]))return VisuMZ[_0x2e7e69(0x12c)][_0x2e7e69(0x17b)](_0x2aa85c),![];return VisuMZ[_0x2e7e69(0x12c)][_0x2e7e69(0x2d4)]['call'](this,_0x2aa85c);},VisuMZ['OptionsCore'][_0x3fa3c2(0x139)]=Input[_0x3fa3c2(0x291)],Input[_0x3fa3c2(0x291)]=function(_0x5edf5d){const _0x4233e1=_0x3fa3c2;if(VisuMZ[_0x4233e1(0x12c)][_0x4233e1(0x136)](_0x5edf5d,!![]))return VisuMZ[_0x4233e1(0x12c)][_0x4233e1(0x17b)](_0x5edf5d),![];return VisuMZ[_0x4233e1(0x12c)][_0x4233e1(0x139)][_0x4233e1(0x206)](this,_0x5edf5d);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x136)]=function(_0x15ebc1,_0x377609){const _0x31de7b=_0x3fa3c2;if(!VisuMZ['OptionsCore'][_0x31de7b(0x27e)][_0x31de7b(0x251)])return![];if(ConfigManager['masterVolume']===undefined)return![];if(!Input[_0x31de7b(0x28f)]('control'))return![];if(_0x15ebc1!=='pageup'&&_0x15ebc1!==_0x31de7b(0x1c3))return![];return _0x377609?VisuMZ[_0x31de7b(0x12c)]['Input_isRepeated'][_0x31de7b(0x206)](Input,_0x15ebc1):VisuMZ[_0x31de7b(0x12c)]['Input_isTriggered'][_0x31de7b(0x206)](Input,_0x15ebc1);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x17b)]=function(_0x56c4b4){const _0x56d2a0=_0x3fa3c2,_0x3fbea4=this['changeMasterVolumeViaShortcut'](_0x56c4b4);this[_0x56d2a0(0x1df)](_0x3fbea4);},VisuMZ['OptionsCore'][_0x3fa3c2(0x1a4)]=function(_0x397b85){const _0x1aadf7=_0x3fa3c2,_0x2ee8de=VisuMZ[_0x1aadf7(0x12c)][_0x1aadf7(0x27e)][_0x1aadf7(0x28d)];let _0x10df10=Math[_0x1aadf7(0x249)](WebAudio[_0x1aadf7(0x2d7)]*0x64);const _0x4eed29=ConfigManager[_0x1aadf7(0x125)];if(_0x397b85==='pageup')_0x10df10+=_0x2ee8de;else _0x397b85===_0x1aadf7(0x1c3)&&(_0x10df10-=_0x2ee8de);_0x10df10=_0x10df10['clamp'](0x0,0x64),ConfigManager['masterVolume']=_0x10df10,ConfigManager[_0x1aadf7(0x1f5)](),_0x10df10/=0x64,WebAudio[_0x1aadf7(0x159)](_0x10df10);if(_0x4eed29!==ConfigManager[_0x1aadf7(0x125)]){if(_0x397b85===_0x1aadf7(0x130))SoundManager[_0x1aadf7(0x239)]();else _0x397b85===_0x1aadf7(0x1c3)&&SoundManager['playMasterVolumeDown']();}return ConfigManager[_0x1aadf7(0x125)]!==_0x4eed29;},VisuMZ[_0x3fa3c2(0x12c)]['updateOptionsCoreScene']=function(_0x280c93){const _0x14898b=_0x3fa3c2;if(!_0x280c93)return;const _0x419f88=SceneManager[_0x14898b(0x212)];if(_0x419f88[_0x14898b(0x2ce)]!==Scene_Options)return;_0x419f88[_0x14898b(0x21e)]['refresh']();},Input[_0x3fa3c2(0x1ea)]=function(_0x5185f4){const _0x13af14=_0x3fa3c2,_0x26276a=[];for(const _0x42b1a6 in Input[_0x13af14(0x173)]){const _0x418dba=Number(_0x42b1a6);if([0x60,0x62,0x64,0x66,0x68,0x20,0x2d]['includes'](_0x418dba))continue;Input['keyMapper'][_0x418dba]===_0x5185f4&&_0x26276a[_0x13af14(0x30b)](_0x418dba);}return _0x26276a;},Input['getGamepadButtonID']=function(_0x82face){const _0x3e6034=_0x3fa3c2,_0x577eb5=[];for(const _0x100907 in Input[_0x3e6034(0x2ad)]){const _0x285c5f=Number(_0x100907);Input['gamepadMapper'][_0x285c5f]===_0x82face&&_0x577eb5[_0x3e6034(0x30b)](_0x285c5f);}return _0x577eb5;},VisuMZ['OptionsCore'][_0x3fa3c2(0xee)]=Input['_updateGamepadState'],Input['_updateGamepadState']=function(_0x4489e9){const _0x3a1286=_0x3fa3c2;VisuMZ[_0x3a1286(0x12c)][_0x3a1286(0xee)][_0x3a1286(0x206)](this,_0x4489e9),this[_0x3a1286(0xfe)]&&(this[_0x3a1286(0x1ba)]=this[_0x3a1286(0x261)][_0x4489e9[_0x3a1286(0x236)]][_0x3a1286(0x1da)](!![]));},VisuMZ[_0x3fa3c2(0x12c)]['DataManager_setupNewGame']=DataManager[_0x3fa3c2(0x27f)],DataManager[_0x3fa3c2(0x27f)]=function(){const _0x46246c=_0x3fa3c2,_0x4dcdbe=($gameSystem?$gameSystem[_0x46246c(0x2d3)]():$dataSystem[_0x46246c(0x2d3)])[_0x46246c(0x2d5)](0x0);VisuMZ[_0x46246c(0x12c)][_0x46246c(0x1b8)][_0x46246c(0x206)](this),$gameSystem[_0x46246c(0x13a)](_0x4dcdbe);},SoundManager[_0x3fa3c2(0x1d8)]=JsonEx[_0x3fa3c2(0x2dd)](VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x1a2)][_0x3fa3c2(0x2cd)]),SoundManager[_0x3fa3c2(0x2ed)]=JsonEx[_0x3fa3c2(0x2dd)](VisuMZ['OptionsCore'][_0x3fa3c2(0x237)]['OptionsSettings'][_0x3fa3c2(0x264)]),SoundManager['cancelSFXs']=JsonEx['makeDeepCopy'](VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['OptionsSettings'][_0x3fa3c2(0x1ad)]),SoundManager[_0x3fa3c2(0xfd)]=JsonEx['makeDeepCopy'](VisuMZ[_0x3fa3c2(0x12c)]['Settings'][_0x3fa3c2(0x1a2)]['SFXBuzzerList']),SoundManager[_0x3fa3c2(0x14b)]=function(){const _0x16414a=_0x3fa3c2,_0x359e0a=[];_0x359e0a[_0x16414a(0x30b)](SoundManager[_0x16414a(0x1d8)]),_0x359e0a[_0x16414a(0x30b)](SoundManager[_0x16414a(0x2ed)]),_0x359e0a[_0x16414a(0x30b)](SoundManager[_0x16414a(0x18e)]),_0x359e0a[_0x16414a(0x30b)](SoundManager[_0x16414a(0xfd)]);let _0x1b20f5=0x0;for(const _0x4f2c8e of _0x359e0a){for(let _0x38fe86=0x1;_0x38fe86<_0x4f2c8e[_0x16414a(0x30f)];_0x38fe86++){const _0x34f46c=_0x4f2c8e[_0x38fe86],_0x1e0dc3=JsonEx[_0x16414a(0x2dd)]($dataSystem[_0x16414a(0x284)][_0x1b20f5]);_0x1e0dc3[_0x16414a(0x176)]=_0x34f46c,_0x4f2c8e[_0x38fe86]=_0x1e0dc3;}_0x1b20f5++;}},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0xf4)]=SoundManager['playCursor'],SoundManager[_0x3fa3c2(0x2d6)]=function(){const _0x216353=_0x3fa3c2;if(ConfigManager&&ConfigManager[_0x216353(0x2b2)]!==undefined){if(ConfigManager[_0x216353(0x2b2)]>0x0){const _0xf2d21d=SoundManager[_0x216353(0x1d8)][ConfigManager[_0x216353(0x2b2)]];if(_0xf2d21d)return AudioManager[_0x216353(0x1de)](_0xf2d21d);}}VisuMZ[_0x216353(0x12c)][_0x216353(0xf4)]['call'](this);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x20d)]=SoundManager[_0x3fa3c2(0x2d8)],SoundManager[_0x3fa3c2(0x2d8)]=function(){const _0x164de6=_0x3fa3c2;if(ConfigManager&&ConfigManager['seOK']!==undefined){if(ConfigManager[_0x164de6(0x28e)]>0x0){const _0x3e3d16=SoundManager[_0x164de6(0x2ed)][ConfigManager[_0x164de6(0x28e)]];if(_0x3e3d16)return AudioManager[_0x164de6(0x1de)](_0x3e3d16);}}VisuMZ[_0x164de6(0x12c)][_0x164de6(0x20d)][_0x164de6(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x242)]=SoundManager[_0x3fa3c2(0x15c)],SoundManager['playCancel']=function(){const _0x5e75e9=_0x3fa3c2;if(ConfigManager&&ConfigManager[_0x5e75e9(0x1cd)]!==undefined){if(ConfigManager[_0x5e75e9(0x1cd)]>0x0){const _0x2b964d=SoundManager[_0x5e75e9(0x18e)][ConfigManager[_0x5e75e9(0x1cd)]];if(_0x2b964d)return AudioManager['playStaticSe'](_0x2b964d);}}VisuMZ[_0x5e75e9(0x12c)][_0x5e75e9(0x242)][_0x5e75e9(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x1e8)]=SoundManager['playBuzzer'],SoundManager[_0x3fa3c2(0x25e)]=function(){const _0x44cf75=_0x3fa3c2;if(ConfigManager&&ConfigManager[_0x44cf75(0x16a)]!==undefined){if(ConfigManager[_0x44cf75(0x16a)]>0x0){const _0x558462=SoundManager[_0x44cf75(0xfd)][ConfigManager['seBuzzer']];if(_0x558462)return AudioManager[_0x44cf75(0x1de)](_0x558462);}}VisuMZ[_0x44cf75(0x12c)][_0x44cf75(0x1e8)]['call'](this);},SoundManager[_0x3fa3c2(0x239)]=function(){const _0x117753=_0x3fa3c2,_0x39f83f=VisuMZ[_0x117753(0x12c)]['Settings'][_0x117753(0x16d)],_0xa1ecde={'name':_0x39f83f['upName'],'volume':_0x39f83f[_0x117753(0x17d)],'pitch':_0x39f83f[_0x117753(0x29d)],'pan':_0x39f83f['upPan']};AudioManager[_0x117753(0x209)](_0xa1ecde);},SoundManager[_0x3fa3c2(0x302)]=function(){const _0x508c1c=_0x3fa3c2,_0x2e99ff=VisuMZ[_0x508c1c(0x12c)]['Settings']['MasterVolShortcut'],_0xdc1575={'name':_0x2e99ff['downName'],'volume':_0x2e99ff[_0x508c1c(0xea)],'pitch':_0x2e99ff[_0x508c1c(0x1e4)],'pan':_0x2e99ff[_0x508c1c(0x141)]};AudioManager[_0x508c1c(0x209)](_0xdc1575);},TextManager[_0x3fa3c2(0x1bc)]=VisuMZ[_0x3fa3c2(0x12c)]['Settings']['OptionsSettings']['FontFaces'],TextManager[_0x3fa3c2(0x308)]={'up':VisuMZ[_0x3fa3c2(0x12c)]['Settings']['Rebind']['up']??'Up','left':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x1d7)]??_0x3fa3c2(0x10f),'down':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x230)]??'Down','right':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x19b)]??'Right','ok':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind']['ok']??_0x3fa3c2(0x11b),'escape':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind'][_0x3fa3c2(0x13b)]??_0x3fa3c2(0x2e3),'cancel':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind'][_0x3fa3c2(0x1f0)]??_0x3fa3c2(0x240),'menu':VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x235)]??_0x3fa3c2(0x1f3),'pageup':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x130)]??_0x3fa3c2(0x2e6),'pagedown':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x1c3)]??_0x3fa3c2(0x29a),'shift':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x2f1)]??_0x3fa3c2(0x1e0),'tab':VisuMZ[_0x3fa3c2(0x12c)]['Settings'][_0x3fa3c2(0x124)][_0x3fa3c2(0x2c8)]??'Tab','buttonFmt':VisuMZ[_0x3fa3c2(0x12c)]['Settings'][_0x3fa3c2(0x124)][_0x3fa3c2(0x1b0)]??'\x5c}Button\x5c{\x20%1','dpadFmt':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x270)]??'\x5c}D-Pad\x5c{\x20%1'},VisuMZ['OptionsCore'][_0x3fa3c2(0x12f)]=TextManager[_0x3fa3c2(0x1ae)],TextManager['getControllerInputButtonString']=function(_0x3541e9,_0x3def32){const _0x561f1a=_0x3fa3c2;if(Scene_Options[_0x561f1a(0x1a3)])return this[_0x561f1a(0x186)](_0x3541e9,_0x3def32);return VisuMZ[_0x561f1a(0x12c)][_0x561f1a(0x12f)]['call'](this,_0x3541e9,_0x3def32);},TextManager[_0x3fa3c2(0x186)]=function(_0x1bf92a,_0x507c4b){const _0x1b586f=_0x3fa3c2,_0x43d7b3=_0x1bf92a['toLowerCase']()[_0x1b586f(0x311)](),_0xa94e16=Input['getGamepadButtonID'](_0x507c4b)[0x0],_0x40cf57=VisuMZ[_0x1b586f(0x12c)][_0x1b586f(0x12f)];if(VisuMZ['OptionsCore']['ControllerButtons'][_0x43d7b3]){const _0x34a71e=VisuMZ[_0x1b586f(0x12c)][_0x1b586f(0x1eb)][_0x43d7b3];return _0x34a71e['button%1'[_0x1b586f(0x2c5)](_0xa94e16)]||_0x40cf57['call'](this,_0x1bf92a,_0x507c4b);}else{if(!!TextManager[_0x1b586f(0x104)](_0x43d7b3)){const _0x4ddf8a=TextManager[_0x1b586f(0x104)](_0x43d7b3);return _0x4ddf8a[_0x1b586f(0x254)['format'](_0xa94e16)]||_0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,_0x507c4b);}else{if(!$gameTemp['_bypassForRebindController']){if(_0xa94e16===0x0)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,'ok');if(_0xa94e16===0x1)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,_0x1b586f(0x1f0));if(_0xa94e16===0x2)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,_0x1b586f(0x2f1));if(_0xa94e16===0x3)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,'menu');if(_0xa94e16===0x4)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,_0x1b586f(0x130));if(_0xa94e16===0x5)return _0x40cf57['call'](this,_0x1bf92a,_0x1b586f(0x1c3));if(_0xa94e16===0xc)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,'up');if(_0xa94e16===0xd)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,'down');if(_0xa94e16===0xe)return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,'left');if(_0xa94e16===0xf)return _0x40cf57['call'](this,_0x1bf92a,_0x1b586f(0x19b));}if([0xc,0xd,0xe,0xf][_0x1b586f(0x26f)](_0xa94e16)){const _0x181fe5=TextManager['REBIND'][_0x1b586f(0x270)];return _0x181fe5[_0x1b586f(0x2c5)](TextManager[_0x1b586f(0x308)][_0x507c4b]);}else{const _0x26c6f3=TextManager[_0x1b586f(0x308)][_0x1b586f(0x1b0)];return _0x26c6f3[_0x1b586f(0x2c5)](_0xa94e16);}}}return _0x40cf57[_0x1b586f(0x206)](this,_0x1bf92a,_0x507c4b);},TextManager[_0x3fa3c2(0x104)]=function(_0x14bf4b){const _0x1e334a=_0x3fa3c2;for(const _0x4671df in VisuMZ['OptionsCore'][_0x1e334a(0x145)]){if(_0x14bf4b[_0x1e334a(0x26f)](_0x4671df)){const _0x1cbf49=VisuMZ[_0x1e334a(0x12c)]['ControllerMatches'][_0x4671df];return VisuMZ[_0x1e334a(0x12c)]['ControllerButtons'][_0x1cbf49];}}return null;};if(Imported[_0x3fa3c2(0x138)]){VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2db)]=Game_Temp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2da)],Game_Temp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2da)]=function(_0x10abe9,_0x4a8e49,_0x411611){const _0x2b990a=_0x3fa3c2;if(!this[_0x2b990a(0x23d)]())return;VisuMZ[_0x2b990a(0x12c)]['Game_Temp_requestAnimation'][_0x2b990a(0x206)](this,_0x10abe9,_0x4a8e49,_0x411611);},Game_Temp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x23d)]=function(){const _0x45d5b8=_0x3fa3c2;if($gameParty['inBattle']()&&ConfigManager&&ConfigManager['battleAniShow']!==undefined)return ConfigManager[_0x45d5b8(0xeb)]>=0x1;return!![];};Game_Temp['prototype']['showFauxAnimations']&&(VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x263)]=Game_Temp['prototype']['showFauxAnimations'],Game_Temp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x27b)]=function(){const _0x32a096=_0x3fa3c2;if($gameParty[_0x32a096(0xec)]()&&ConfigManager&&ConfigManager[_0x32a096(0xeb)]!==undefined)return ConfigManager[_0x32a096(0xeb)]>=0x2;return VisuMZ[_0x32a096(0x12c)][_0x32a096(0x263)][_0x32a096(0x206)](this);});;};VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x30e)]=Game_System[_0x3fa3c2(0x16e)][_0x3fa3c2(0x305)],Game_System[_0x3fa3c2(0x16e)][_0x3fa3c2(0x305)]=function(){const _0x2c8650=_0x3fa3c2;VisuMZ[_0x2c8650(0x12c)]['Game_System_initialize'][_0x2c8650(0x206)](this),this['initOptionsCore']();},Game_System['prototype'][_0x3fa3c2(0x2df)]=function(){const _0x37f532=_0x3fa3c2;this[_0x37f532(0x259)]=JsonEx[_0x37f532(0x2dd)]($dataSystem['windowTone']);},Game_System[_0x3fa3c2(0x16e)]['windowTone']=function(){const _0x1b0ebb=_0x3fa3c2;if(this[_0x1b0ebb(0x259)])return this['_windowTone'];return this[_0x1b0ebb(0x2df)](),this['_windowTone'];},VisuMZ[_0x3fa3c2(0x12c)]['Game_System_mainFontFace']=Game_System[_0x3fa3c2(0x16e)][_0x3fa3c2(0x24f)],Game_System[_0x3fa3c2(0x16e)][_0x3fa3c2(0x24f)]=function(){const _0x6de923=_0x3fa3c2,_0x4b9460=VisuMZ[_0x6de923(0x12c)]['Game_System_mainFontFace']['call'](this);if(ConfigManager&&ConfigManager[_0x6de923(0x25b)]!==undefined){if(ConfigManager[_0x6de923(0x25b)]>0x0)return TextManager[_0x6de923(0x1bc)][ConfigManager[_0x6de923(0x25b)]]||_0x4b9460;}return _0x4b9460;},VisuMZ['OptionsCore'][_0x3fa3c2(0x14f)]=Game_Action['prototype'][_0x3fa3c2(0x2e4)],Game_Action[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2e4)]=function(_0x3820a9,_0x478723){const _0x129818=_0x3fa3c2;if(ConfigManager[_0x129818(0x199)]){if(this['subject']()[_0x129818(0x18d)]()&&_0x3820a9[_0x129818(0x18f)]()){if(ConfigManager[_0x129818(0x2ca)])_0x478723=Math[_0x129818(0xfc)](_0x478723,_0x3820a9[_0x129818(0x24c)]);}}VisuMZ[_0x129818(0x12c)][_0x129818(0x14f)]['call'](this,_0x3820a9,_0x478723);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2c4)]=Game_BattlerBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a7)],Game_BattlerBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a7)]=function(_0x4fc733){const _0xf68b40=_0x3fa3c2;if(ConfigManager[_0xf68b40(0x199)]&&this[_0xf68b40(0x18d)]()){if(ConfigManager[_0xf68b40(0x2bb)]&&_0x4fc733===this['deathStateId']())return!![];if(Imported['VisuMZ_1_SkillsStatesCore']&&ConfigManager['assistResistNegatives']){const _0x43b3c0=$dataStates[_0x4fc733];if(_0x43b3c0&&_0x43b3c0['categories']&&_0x43b3c0[_0xf68b40(0x21b)][_0xf68b40(0x26f)]('NEGATIVE'))return!![];}}return VisuMZ[_0xf68b40(0x12c)][_0xf68b40(0x2c4)]['call'](this,_0x4fc733);},VisuMZ['OptionsCore'][_0x3fa3c2(0x16f)]=Game_Battler[_0x3fa3c2(0x16e)]['useItem'],Game_Battler[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2e0)]=function(_0x1231d4){const _0x259cac=_0x3fa3c2;if(ConfigManager&&ConfigManager[_0x259cac(0x199)]&&this[_0x259cac(0x18d)]()){if(DataManager['isSkill'](_0x1231d4)&&ConfigManager[_0x259cac(0x13d)]===![])return;if(DataManager[_0x259cac(0x2bd)](_0x1231d4)&&ConfigManager[_0x259cac(0x14e)]===![])return;}VisuMZ[_0x259cac(0x12c)][_0x259cac(0x16f)][_0x259cac(0x206)](this,_0x1231d4);},VisuMZ[_0x3fa3c2(0x12c)]['Game_Battler_addDebuff']=Game_Battler[_0x3fa3c2(0x16e)][_0x3fa3c2(0x195)],Game_Battler[_0x3fa3c2(0x16e)][_0x3fa3c2(0x195)]=function(_0x4df373,_0x17bdbb){const _0x2047d2=_0x3fa3c2;if(ConfigManager[_0x2047d2(0x199)]&&this['isActor']()){if(Imported[_0x2047d2(0x20c)]&&ConfigManager['assistResistNegatives'])return!![];}VisuMZ['OptionsCore'][_0x2047d2(0x187)][_0x2047d2(0x206)](this,_0x4df373,_0x17bdbb);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2f4)]=Game_Enemy[_0x3fa3c2(0x16e)][_0x3fa3c2(0x24d)],Game_Enemy[_0x3fa3c2(0x16e)]['dropItemRate']=function(){const _0x453bd0=_0x3fa3c2;let _0x1360a8=VisuMZ[_0x453bd0(0x12c)][_0x453bd0(0x2f4)]['call'](this);return ConfigManager[_0x453bd0(0x199)]&&(_0x1360a8*=0x2**(ConfigManager[_0x453bd0(0x29c)]||0x0)),_0x1360a8;},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x23c)]=Game_Party[_0x3fa3c2(0x16e)][_0x3fa3c2(0x180)],Game_Party[_0x3fa3c2(0x16e)]['hasEncounterHalf']=function(){const _0x10662f=_0x3fa3c2;if(ConfigManager[_0x10662f(0x199)]&&ConfigManager[_0x10662f(0x1f4)]===0x1)return!![];if(ConfigManager[_0x10662f(0xf1)]===0x1)return!![];return VisuMZ['OptionsCore'][_0x10662f(0x23c)][_0x10662f(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)]['Game_Party_hasEncounterNone']=Game_Party['prototype'][_0x3fa3c2(0xef)],Game_Party[_0x3fa3c2(0x16e)][_0x3fa3c2(0xef)]=function(){const _0x3a6d0a=_0x3fa3c2;if(ConfigManager[_0x3a6d0a(0x199)]&&ConfigManager['assistRandomEncounters']===0x0)return!![];if(ConfigManager[_0x3a6d0a(0xf1)]===0x0)return!![];return VisuMZ[_0x3a6d0a(0x12c)][_0x3a6d0a(0x1c7)][_0x3a6d0a(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x17a)]=Game_Troop['prototype'][_0x3fa3c2(0x163)],Game_Troop[_0x3fa3c2(0x16e)]['expTotal']=function(){const _0x20fdba=_0x3fa3c2;let _0x27015e=VisuMZ['OptionsCore'][_0x20fdba(0x17a)]['call'](this);return ConfigManager[_0x20fdba(0x199)]&&(_0x27015e*=0x2**(ConfigManager['assistExpMultiplier']||0x0)),_0x27015e;},VisuMZ[_0x3fa3c2(0x12c)]['Game_Troop_goldRate']=Game_Troop['prototype'][_0x3fa3c2(0x190)],Game_Troop['prototype'][_0x3fa3c2(0x190)]=function(){const _0x378cb3=_0x3fa3c2;let _0x11237b=VisuMZ['OptionsCore']['Game_Troop_goldRate']['call'](this);return ConfigManager[_0x378cb3(0x199)]&&(_0x11237b*=0x2**(ConfigManager[_0x378cb3(0x19e)]||0x0)),_0x11237b;};var uiDefault=uiDefault||{};function _0x36d3(_0x1ea65b,_0x527a43){const _0x10d2fc=_0x10d2();return _0x36d3=function(_0x36d3d9,_0x18cb02){_0x36d3d9=_0x36d3d9-0xea;let _0x3f5029=_0x10d2fc[_0x36d3d9];return _0x3f5029;},_0x36d3(_0x1ea65b,_0x527a43);}uiDefault['HelpPosition']=Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0xf7)],Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0xf7)]=function(){const _0x5b3bde=_0x3fa3c2;return ConfigManager[_0x5b3bde(0x2f2)]&&ConfigManager[_0x5b3bde(0x1cb)]!==undefined?ConfigManager[_0x5b3bde(0x1cb)]:uiDefault[_0x5b3bde(0x295)][_0x5b3bde(0x206)](this);},uiDefault[_0x3fa3c2(0xf6)]=Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2a5)],Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2a5)]=function(){const _0x1789d2=_0x3fa3c2;return ConfigManager[_0x1789d2(0x184)]!==undefined?ConfigManager['uiButtonPosition']:uiDefault[_0x1789d2(0xf6)]['call'](this);},uiDefault[_0x3fa3c2(0x129)]=Scene_Base[_0x3fa3c2(0x16e)]['isRightInputMode'],Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2fd)]=function(){const _0xffb582=_0x3fa3c2;return ConfigManager[_0xffb582(0x2f2)]&&ConfigManager['uiInputPosition']!==undefined?ConfigManager[_0xffb582(0x248)]:uiDefault[_0xffb582(0x129)][_0xffb582(0x206)](this);},Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a5)]=function(){const _0x530575=_0x3fa3c2;this[_0x530575(0x135)]&&(this['_cancelButton']['visible']=ConfigManager['touchUI']),this[_0x530575(0x2b4)]&&(this[_0x530575(0x2b4)]['visible']=ConfigManager['touchUI']),this['_pagedownButton']&&(this['_pagedownButton']['visible']=ConfigManager[_0x530575(0x21d)]);},Scene_Base['prototype']['optionsCoreUpdateButtonPositions']=function(){const _0x3a48f1=_0x3fa3c2;this[_0x3a48f1(0x135)]&&(this[_0x3a48f1(0x135)]['y']=this[_0x3a48f1(0x275)]()),this[_0x3a48f1(0x2b4)]&&(this[_0x3a48f1(0x2b4)]['y']=this[_0x3a48f1(0x275)](),Graphics[_0x3a48f1(0x166)]()&&!this[_0x3a48f1(0x2a5)]()&&(this['_pageupButton']['y']+=0x32)),this[_0x3a48f1(0x146)]&&(this[_0x3a48f1(0x146)]['y']=this[_0x3a48f1(0x275)](),Graphics['_isFPSCounterOn']()&&!this[_0x3a48f1(0x2a5)]()&&(this[_0x3a48f1(0x146)]['y']+=0x32));},VisuMZ['OptionsCore'][_0x3fa3c2(0x22d)]=Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2c1)],Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2c1)]=function(){const _0x52cd96=_0x3fa3c2;return ConfigManager[_0x52cd96(0x21d)]?VisuMZ[_0x52cd96(0x12c)][_0x52cd96(0x22d)][_0x52cd96(0x206)](this):this[_0x52cd96(0x172)]();},Scene_Base[_0x3fa3c2(0x16e)][_0x3fa3c2(0x172)]=function(){const _0x4e63e0=_0x3fa3c2;if(this['_windowLayer']&&this[_0x4e63e0(0x1c9)][_0x4e63e0(0x11d)])for(const _0x43fd02 of this[_0x4e63e0(0x1c9)][_0x4e63e0(0x11d)]){if(!_0x43fd02)continue;if(!_0x43fd02[_0x4e63e0(0x18c)])continue;if(!_0x43fd02[_0x4e63e0(0x169)])continue;if(_0x43fd02[_0x4e63e0(0x169)]['pageup'])return TextManager['buttonAssistSwitch'];}return'';},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x160)]=Scene_MenuBase[_0x3fa3c2(0x16e)]['createPageButtons'],Scene_MenuBase[_0x3fa3c2(0x16e)]['createPageButtons']=function(){const _0x58919c=_0x3fa3c2;VisuMZ['OptionsCore'][_0x58919c(0x160)]['call'](this),Graphics['_isFPSCounterOn']()&&!this[_0x58919c(0x2a5)]()&&(this[_0x58919c(0x2b4)]['y']+=0x32,this[_0x58919c(0x146)]['y']+=0x32);},Scene_MenuBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a5)]=function(){const _0x1c63d7=_0x3fa3c2;if(!this[_0x1c63d7(0x135)])this[_0x1c63d7(0x207)]();Scene_Base[_0x1c63d7(0x16e)][_0x1c63d7(0x1a5)][_0x1c63d7(0x206)](this);},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x196)]=Scene_Title[_0x3fa3c2(0x16e)][_0x3fa3c2(0x161)],Scene_Title[_0x3fa3c2(0x16e)]['update']=function(){const _0x5c3153=_0x3fa3c2;this[_0x5c3153(0x2dc)](),VisuMZ[_0x5c3153(0x12c)]['Scene_Title_update'][_0x5c3153(0x206)](this);},Scene_Title[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2dc)]=function(){const _0x8e8c89=_0x3fa3c2;if(ConfigManager[_0x8e8c89(0x199)])return;if($gameTemp['isPlaytest']())return;if(Input[_0x8e8c89(0x1fc)]('down'))this['processOptionsCoreFailsafe'](0x2);if(Input[_0x8e8c89(0x1fc)]('left'))this[_0x8e8c89(0x255)](0x4);if(Input[_0x8e8c89(0x1fc)](_0x8e8c89(0x19b)))this['processOptionsCoreFailsafe'](0x6);if(Input[_0x8e8c89(0x1fc)]('up'))this[_0x8e8c89(0x255)](0x8);},Scene_Title[_0x3fa3c2(0x16e)][_0x3fa3c2(0x255)]=function(_0x5d465d){const _0x54bc15=_0x3fa3c2,_0xba1b3b=[0x8,0x8,0x2,0x2,0x4,0x6,0x4,0x6];this[_0x54bc15(0x1ac)]=this[_0x54bc15(0x1ac)]||0x0,_0x5d465d===_0xba1b3b[this[_0x54bc15(0x1ac)]]?this[_0x54bc15(0x1ac)]++:this[_0x54bc15(0x1ac)]=0x0,this[_0x54bc15(0x1ac)]===_0xba1b3b[_0x54bc15(0x30f)]&&(ConfigManager[_0x54bc15(0x199)]=!![],ConfigManager['save'](),SoundManager[_0x54bc15(0x11a)]());},VisuMZ['OptionsCore'][_0x3fa3c2(0x244)]=Scene_Map[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1f1)],Scene_Map['prototype'][_0x3fa3c2(0x1f1)]=function(){const _0x2b4fa6=_0x3fa3c2;VisuMZ[_0x2b4fa6(0x12c)]['Scene_Map_updateMainMultiply']['call'](this),ConfigManager[_0x2b4fa6(0x199)]&&ConfigManager[_0x2b4fa6(0x2b1)]&&!$gameMessage[_0x2b4fa6(0x205)]()&&this[_0x2b4fa6(0x10a)]();},Scene_Map[_0x3fa3c2(0x16e)][_0x3fa3c2(0x10a)]=function(){const _0x3b2035=_0x3fa3c2;let _0xaa8210=ConfigManager['assistMapSpeed']||0x0;while(_0xaa8210--){this[_0x3b2035(0x1c1)]();}},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x296)]=Scene_Battle['prototype']['update'],Scene_Battle[_0x3fa3c2(0x16e)][_0x3fa3c2(0x161)]=function(){const _0x32974b=_0x3fa3c2;VisuMZ[_0x32974b(0x12c)]['Scene_Battle_update'][_0x32974b(0x206)](this);if(ConfigManager[_0x32974b(0x1bd)])this['updateBattleAniSpeed']();},Scene_Battle[_0x3fa3c2(0x16e)][_0x3fa3c2(0x309)]=function(){const _0x4bfaba=_0x3fa3c2;if(this['allowUpdateBattleAniSpeed']()){this[_0x4bfaba(0x120)]=!![];let _0xe43096=ConfigManager[_0x4bfaba(0x1bd)];while(_0xe43096--){this[_0x4bfaba(0x161)](),SceneManager[_0x4bfaba(0x1dd)]();}this[_0x4bfaba(0x120)]=![];}},Scene_Battle[_0x3fa3c2(0x16e)][_0x3fa3c2(0x131)]=function(){const _0x4f42da=_0x3fa3c2;return!BattleManager[_0x4f42da(0x116)]()&&!this[_0x4f42da(0x120)]&&!$gameMessage['isBusy']();},Scene_Options[_0x3fa3c2(0x1a3)]=VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x147)]&&Imported[_0x3fa3c2(0x138)]&&VisuMZ['CoreEngine'][_0x3fa3c2(0x293)]>1.65,Scene_Options['prototype'][_0x3fa3c2(0x193)]=function(){return 0x0;},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x110)]=function(){const _0xe8102d=_0x3fa3c2;return this[_0xe8102d(0x2c2)]&&this[_0xe8102d(0x2c2)][_0xe8102d(0x110)]();},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2a4)]=function(){const _0xfbeb9b=_0x3fa3c2;Scene_MenuBase[_0xfbeb9b(0x16e)][_0xfbeb9b(0x2a4)][_0xfbeb9b(0x206)](this),this['createCategoryWindow'](),this[_0xfbeb9b(0x246)](),this[_0xfbeb9b(0x28a)]();if(Imported[_0xfbeb9b(0x138)]){}this[_0xfbeb9b(0x14a)]();},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2d2)]=function(){const _0x447f9f=_0x3fa3c2,_0x3c8867=this[_0x447f9f(0x26e)]();this['_categoryWindow']=new Window_OptionsCategory(_0x3c8867),this[_0x447f9f(0x23e)](this[_0x447f9f(0x2c2)]),!this['isUseModernControls']()&&(this[_0x447f9f(0x2c2)][_0x447f9f(0x219)]('category',this[_0x447f9f(0x2e7)]['bind'](this)),this[_0x447f9f(0x2c2)][_0x447f9f(0x219)](_0x447f9f(0x1f0),this[_0x447f9f(0x210)][_0x447f9f(0x155)](this)));},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x26e)]=function(){const _0x22c1c2=_0x3fa3c2,_0x270146=Graphics[_0x22c1c2(0x25d)],_0x43296e=this['calcWindowHeight'](0x1,!![]),_0x8f85e5=0x0,_0x1e25b6=this[_0x22c1c2(0x300)]();return new Rectangle(_0x8f85e5,_0x1e25b6,_0x270146,_0x43296e);},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x246)]=function(){const _0x2a0205=_0x3fa3c2,_0xac2f7a=this[_0x2a0205(0x1ef)]();this[_0x2a0205(0x21e)]=new Window_Options(_0xac2f7a),this[_0x2a0205(0x23e)](this[_0x2a0205(0x21e)]),this[_0x2a0205(0x21e)][_0x2a0205(0x219)](_0x2a0205(0x1f0),this[_0x2a0205(0x19d)][_0x2a0205(0x155)](this)),this[_0x2a0205(0x2c2)]['setListWindow'](this[_0x2a0205(0x21e)]),this[_0x2a0205(0x110)]()?(this['_optionsWindow'][_0x2a0205(0x1e5)](),this[_0x2a0205(0x21e)][_0x2a0205(0x307)](0x0)):(this[_0x2a0205(0x21e)]['deactivate'](),this[_0x2a0205(0x21e)]['deselect']());},Scene_Options[_0x3fa3c2(0x16e)]['optionsWindowRect']=function(){const _0x26b251=_0x3fa3c2,_0x1141e3=Graphics[_0x26b251(0x25d)],_0xc62cc=this['mainAreaHeight']()-this[_0x26b251(0x2c2)][_0x26b251(0x2ae)],_0x57876f=0x0,_0x46a42c=this[_0x26b251(0x2c2)]['y']+this['_categoryWindow'][_0x26b251(0x2ae)];return new Rectangle(_0x57876f,_0x46a42c,_0x1141e3,_0xc62cc);},Scene_Options[_0x3fa3c2(0x16e)]['postCreateWindows']=function(){const _0x1f7c13=_0x3fa3c2;if($gameTemp['_returnOptionsCore']!==undefined){const _0x18c3a6=$gameTemp[_0x1f7c13(0xfb)];this['_categoryWindow']['smoothSelect'](_0x18c3a6['category']),this[_0x1f7c13(0x2c2)][_0x1f7c13(0x161)](),this[_0x1f7c13(0x110)]()?this['_categoryWindow'][_0x1f7c13(0x1e5)]():this['_categoryWindow'][_0x1f7c13(0x103)](),this[_0x1f7c13(0x21e)][_0x1f7c13(0x1e5)](),this[_0x1f7c13(0x21e)]['_index']=_0x18c3a6[_0x1f7c13(0x236)],this[_0x1f7c13(0x21e)][_0x1f7c13(0x13c)]=_0x18c3a6[_0x1f7c13(0x1f8)],this[_0x1f7c13(0x21e)]['_scrollY']=_0x18c3a6[_0x1f7c13(0x203)],this[_0x1f7c13(0x21e)]['_scrollDuration']=0x0,this[_0x1f7c13(0x21e)]['refreshCursor'](),this['_optionsWindow'][_0x1f7c13(0x161)](),$gameTemp[_0x1f7c13(0xfb)]=undefined;}},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2e7)]=function(){const _0x58011c=_0x3fa3c2;this[_0x58011c(0x21e)][_0x58011c(0x1e5)](),this['_optionsWindow']['smoothSelect'](0x0);},Scene_Options[_0x3fa3c2(0x16e)]['onListCancel']=function(){const _0x504f7c=_0x3fa3c2;this[_0x504f7c(0x110)]()?this[_0x504f7c(0x210)]():(this[_0x504f7c(0x2c2)]['activate'](),this[_0x504f7c(0x21e)][_0x504f7c(0x1cc)]());},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x26c)]=function(){const _0x2d10dd=_0x3fa3c2;Scene_MenuBase['prototype'][_0x2d10dd(0x26c)]['call'](this),this[_0x2d10dd(0x276)]();},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x276)]=function(){const _0x318a63=_0x3fa3c2;if(this[_0x318a63(0x2c2)]){const _0x24fef0=this[_0x318a63(0x26e)]();this[_0x318a63(0x2c2)]['move'](_0x24fef0['x'],_0x24fef0['y'],_0x24fef0[_0x318a63(0x224)],_0x24fef0['height']);}if(this[_0x318a63(0x21e)]){const _0x46c97d=this[_0x318a63(0x1ef)]();this['_optionsWindow'][_0x318a63(0x22f)](_0x46c97d['x'],_0x46c97d['y'],_0x46c97d['width'],_0x46c97d[_0x318a63(0x2ae)]);}if(this['_buttonAssistWindow']){const _0x2ab5cf=this[_0x318a63(0x213)]();this[_0x318a63(0x137)][_0x318a63(0x22f)](_0x2ab5cf['x'],_0x2ab5cf['y'],_0x2ab5cf['width'],_0x2ab5cf['height']),this[_0x318a63(0x137)][_0x318a63(0x177)]();}this[_0x318a63(0x20e)]();},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2c1)]=function(){const _0x31f17e=_0x3fa3c2;return VisuMZ[_0x31f17e(0x12c)][_0x31f17e(0x237)]['OptionsSettings'][_0x31f17e(0x12e)];},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x20e)]=function(){const _0x5cdd43=_0x3fa3c2;this[_0x5cdd43(0x2c2)]&&(this[_0x5cdd43(0x2c2)][_0x5cdd43(0x177)](),this['_categoryWindow']['refreshCursor']()),this[_0x5cdd43(0x21e)]&&(this[_0x5cdd43(0x21e)]['refresh'](),this[_0x5cdd43(0x21e)]['refreshCursor']()),this['_buttonAssistWindow']&&this[_0x5cdd43(0x137)][_0x5cdd43(0x177)]();},Scene_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x26d)]=function(){const _0x14ffb5=_0x3fa3c2,_0x134c9d=Scene_Options['layoutSettings'][_0x14ffb5(0x225)]||0x0,_0x5776c1=[this[_0x14ffb5(0x2c2)],this[_0x14ffb5(0x21e)],this['_buttonAssistWindow']];for(const _0x41f16b of _0x5776c1){if(_0x41f16b)_0x41f16b['setBackgroundType'](_0x134c9d);}},Scene_Options[_0x3fa3c2(0x16e)]['updateOptionsSceneBgTypes']=function(){const _0x48c43e=_0x3fa3c2,_0x269c53=VisuMZ[_0x48c43e(0x12c)][_0x48c43e(0x237)][_0x48c43e(0x1a2)];if(this[_0x48c43e(0x2c2)]){const _0x5158e2=_0x269c53[_0x48c43e(0x189)]??0x0;this[_0x48c43e(0x2c2)][_0x48c43e(0x2b5)](_0x5158e2);}if(this[_0x48c43e(0x21e)]){const _0xd0810d=_0x269c53[_0x48c43e(0x272)]??0x0;this['_optionsWindow'][_0x48c43e(0x2b5)](_0xd0810d);}if(this[_0x48c43e(0x137)]){const _0x5569ef=_0x269c53['buttonAssistBgType']??0x0;this[_0x48c43e(0x137)][_0x48c43e(0x2b5)](_0x5569ef);}};function Scene_RebindBase(){const _0x213ca0=_0x3fa3c2;this[_0x213ca0(0x305)](...arguments);}Scene_RebindBase[_0x3fa3c2(0x16e)]=Object[_0x3fa3c2(0x2a4)](Scene_MenuBase[_0x3fa3c2(0x16e)]),Scene_RebindBase['prototype']['constructor']=Scene_RebindBase,Scene_RebindBase[_0x3fa3c2(0x10d)]={'helpBgType':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)]['HelpWindow_BgType']??0x0,'inputBgType':VisuMZ[_0x3fa3c2(0x12c)]['Settings']['Rebind'][_0x3fa3c2(0x117)]??0x0},Scene_RebindBase[_0x3fa3c2(0x16e)]['initialize']=function(){const _0x21a93c=_0x3fa3c2;Scene_MenuBase[_0x21a93c(0x16e)]['initialize'][_0x21a93c(0x206)](this),document[_0x21a93c(0x144)](_0x21a93c(0x1fd),this[_0x21a93c(0x285)][_0x21a93c(0x155)](this));if(!Imported[_0x21a93c(0x138)]){let _0x39b7b2='This\x20feature\x20requires\x20VisuMZ_0_CoreEngine\x20to\x20work!';alert(_0x39b7b2),SceneManager[_0x21a93c(0x2c6)]();}else{if(VisuMZ[_0x21a93c(0x2bf)][_0x21a93c(0x293)]<1.8){let _0x4f4e53='';_0x4f4e53+=_0x21a93c(0x1dc),_0x4f4e53+=_0x21a93c(0x2e9),alert(_0x4f4e53),SceneManager[_0x21a93c(0x2c6)]();}}},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x214)]=function(){const _0xc86616=_0x3fa3c2;return TextManager['getInputButtonString'](_0xc86616(0x2f1));},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x232)]=function(){const _0x40a1f4=_0x3fa3c2;return Window_KeyRebinds[_0x40a1f4(0x10d)][_0x40a1f4(0x218)]['remove'];},Scene_RebindBase['prototype'][_0x3fa3c2(0x143)]=function(){const _0x509fb6=_0x3fa3c2;return Window_KeyRebinds[_0x509fb6(0x10d)][_0x509fb6(0x218)]['confirm'];},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2f7)]=function(){const _0x328636=_0x3fa3c2;return Window_KeyRebinds[_0x328636(0x10d)][_0x328636(0x218)][_0x328636(0x1f0)];},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2a4)]=function(){const _0x443b86=_0x3fa3c2;Scene_MenuBase['prototype'][_0x443b86(0x2a4)][_0x443b86(0x206)](this),this[_0x443b86(0x16b)](),this[_0x443b86(0x179)](),this[_0x443b86(0x2f6)]();},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x16b)]=function(){const _0x37ad90=_0x3fa3c2;Scene_MenuBase['prototype'][_0x37ad90(0x16b)][_0x37ad90(0x206)](this),this['_helpWindow'][_0x37ad90(0x2b5)](Scene_RebindBase[_0x37ad90(0x10d)][_0x37ad90(0x181)]);},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x179)]=function(){const _0xdf2f63=_0x3fa3c2,_0x3e8733=this[_0xdf2f63(0x142)](),_0x344d73=new Window_KeyRebinds(_0x3e8733);this[_0xdf2f63(0x23e)](_0x344d73),_0x344d73['setHandler'](_0xdf2f63(0x1a8),this['startRebind'][_0xdf2f63(0x155)](this)),_0x344d73[_0xdf2f63(0x219)](_0xdf2f63(0x1f0),this[_0xdf2f63(0x210)]['bind'](this)),_0x344d73[_0xdf2f63(0x19c)](this[_0xdf2f63(0x1c4)]),_0x344d73[_0xdf2f63(0x2b5)](Window_KeyRebinds[_0xdf2f63(0x10d)][_0xdf2f63(0x2d9)]),this[_0xdf2f63(0x121)]=_0x344d73;},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x142)]=function(){const _0x2c2528=_0x3fa3c2;if(VisuMZ[_0x2c2528(0x12c)][_0x2c2528(0x237)][_0x2c2528(0x124)]['RebindWindow_RectJS'])return VisuMZ['OptionsCore']['Settings'][_0x2c2528(0x124)][_0x2c2528(0xff)][_0x2c2528(0x206)](this);const _0x5dc767=0x30,_0x1035f7=Math['ceil']((Graphics[_0x2c2528(0x25d)]-_0x5dc767*0x2)*(this[_0x2c2528(0x204)]()?0x2/0x3:0x1)),_0x2ffd97=this[_0x2c2528(0x11f)]()-_0x5dc767*0x2,_0x1a2869=Math[_0x2c2528(0x194)]((Graphics['boxWidth']-_0x1035f7)/0x2),_0x1cc7aa=this['mainAreaTop']()+Math['floor']((this[_0x2c2528(0x11f)]()-_0x2ffd97)/0x2);return new Rectangle(_0x1a2869,_0x1cc7aa,_0x1035f7,_0x2ffd97);},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2b8)]=function(){return![];},Scene_RebindBase['prototype'][_0x3fa3c2(0x204)]=function(){return![];},Scene_RebindBase['prototype'][_0x3fa3c2(0x2f6)]=function(){const _0x8dac63=_0x3fa3c2,_0x101b41=this[_0x8dac63(0x11e)](),_0x599dbd=new Window_RebindHelp(_0x101b41);this[_0x8dac63(0x228)](_0x599dbd),_0x599dbd[_0x8dac63(0x150)]=0x0,_0x599dbd[_0x8dac63(0x2b5)](Scene_RebindBase[_0x8dac63(0x10d)][_0x8dac63(0x234)]),this[_0x8dac63(0x17c)]=_0x599dbd;},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x11e)]=function(){const _0x24bd54=_0x3fa3c2;if(VisuMZ[_0x24bd54(0x12c)][_0x24bd54(0x237)]['Rebind']['HelpRebindWindow_RectJS'])return VisuMZ[_0x24bd54(0x12c)]['Settings'][_0x24bd54(0x124)]['HelpRebindWindow_RectJS'][_0x24bd54(0x206)](this);const _0x26c692=Math[_0x24bd54(0x192)](Graphics[_0x24bd54(0x25d)]*0x2/0x3),_0x5962e7=this[_0x24bd54(0x118)](0x2,![]),_0x1b9d2b=Math[_0x24bd54(0x194)]((Graphics[_0x24bd54(0x25d)]-_0x26c692)/0x2),_0x198934=Math['floor']((Graphics[_0x24bd54(0x252)]-_0x5962e7)/0x2);return new Rectangle(_0x1b9d2b,_0x198934,_0x26c692,_0x5962e7);},Scene_RebindBase[_0x3fa3c2(0x16e)]['startRebind']=function(){const _0x53c9a0=_0x3fa3c2;Input[_0x53c9a0(0x2a6)](),TouchInput['clear'](),this[_0x53c9a0(0x1c4)][_0x53c9a0(0x2a6)](),this[_0x53c9a0(0x17c)][_0x53c9a0(0x1ed)](),this['_inputMsgWindow']['setText'](this[_0x53c9a0(0x1fb)]());},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1fb)]=function(){return'-';},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x285)]=function(_0x25fe06){const _0x20ff66=_0x3fa3c2;this['_inputMsgWindow'][_0x20ff66(0x19a)]()&&(Input['clear'](),TouchInput[_0x20ff66(0x2a6)](),this['processEventKeyDown'](_0x25fe06));},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1f2)]=function(_0x1aa545){const _0x2dc58d=_0x3fa3c2,_0x40356c=_0x1aa545[_0x2dc58d(0x20a)];if(_0x40356c===0x1b)this['cancelRebinding']();else{if(this['isForKeyboard']()&&this['isForbiddenKeycode'](_0x40356c))this[_0x2dc58d(0x2aa)]();else this[_0x2dc58d(0x2b8)]()&&this[_0x2dc58d(0x23b)](_0x40356c);}},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1d0)]=function(){const _0x53d25b=_0x3fa3c2;SoundManager['playCancel'](),this[_0x53d25b(0x17c)][_0x53d25b(0x25c)](),this['_rebindWindow'][_0x53d25b(0x1e5)](),this[_0x53d25b(0x121)][_0x53d25b(0x177)]();},Scene_RebindBase['prototype']['isForbiddenKeycode']=function(_0x6dd0f6){return!![];},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2aa)]=function(){const _0x441235=_0x3fa3c2;SoundManager[_0x441235(0x25e)]();const _0xee44de=Window_KeyRebinds[_0x441235(0x10d)][_0x441235(0x15e)][_0x441235(0x1d1)];this['_inputMsgWindow'][_0x441235(0x108)](_0xee44de);},Scene_RebindBase[_0x3fa3c2(0x16e)][_0x3fa3c2(0x23b)]=function(_0x36456e){const _0x4181ef=_0x3fa3c2;this[_0x4181ef(0x27c)](_0x36456e),$gameMap[_0x4181ef(0x1c2)](),Input[_0x4181ef(0x2a6)](),TouchInput['clear'](),SoundManager[_0x4181ef(0x217)](),this[_0x4181ef(0x17c)][_0x4181ef(0x25c)](),this[_0x4181ef(0x121)][_0x4181ef(0x1e5)](),this[_0x4181ef(0x121)][_0x4181ef(0x177)](),ConfigManager[_0x4181ef(0x1f5)]();};function Scene_RebindKeyboard(){const _0xb7e671=_0x3fa3c2;this[_0xb7e671(0x305)](...arguments);}Scene_RebindKeyboard['prototype']=Object[_0x3fa3c2(0x2a4)](Scene_RebindBase[_0x3fa3c2(0x16e)]),Scene_RebindKeyboard['prototype']['constructor']=Scene_RebindKeyboard,Scene_RebindKeyboard[_0x3fa3c2(0x16e)]['initialize']=function(){const _0x5b8d06=_0x3fa3c2;Scene_RebindBase['prototype'][_0x5b8d06(0x305)][_0x5b8d06(0x206)](this);},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2b8)]=function(){return!![];},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x303)]=function(){const _0x36d316=_0x3fa3c2;Scene_RebindBase[_0x36d316(0x16e)][_0x36d316(0x303)][_0x36d316(0x206)](this),this['_replaceKeyID']=this[_0x36d316(0x121)][_0x36d316(0x20a)]();},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1fb)]=function(){const _0x29a876=_0x3fa3c2;return Window_KeyRebinds[_0x29a876(0x10d)]['helpText'][_0x29a876(0x2a2)];},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x310)]=function(_0x4a0578){const _0x522c48=_0x3fa3c2,_0x360f5e=[];_0x360f5e[_0x522c48(0x30b)](0xc0);for(let _0xd8962f=0x30;_0xd8962f<=0x39;_0xd8962f++)_0x360f5e['push'](_0xd8962f);for(let _0x47d788=0x41;_0x47d788<=0x5a;_0x47d788++)_0x360f5e[_0x522c48(0x30b)](_0x47d788);for(let _0x453bb1=0xba;_0x453bb1<=0xc0;_0x453bb1++)_0x360f5e[_0x522c48(0x30b)](_0x453bb1);for(let _0xe28c91=0xdb;_0xe28c91<=0xde;_0xe28c91++)_0x360f5e[_0x522c48(0x30b)](_0xe28c91);return!_0x360f5e[_0x522c48(0x26f)](_0x4a0578);},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x27c)]=function(_0x4cf051){const _0x138beb=_0x3fa3c2;Input[_0x138beb(0x173)][this['_replaceKeyID']]=Input[_0x138beb(0x173)][_0x4cf051]||undefined;const _0x5496cf=this[_0x138beb(0x121)][_0x138beb(0x10b)]();Input['keyMapper'][_0x4cf051]=_0x5496cf,Input['keyMapper'][-0x1]=undefined,this['reassignCoreEngineControls']();},Scene_RebindKeyboard[_0x3fa3c2(0x16e)][_0x3fa3c2(0x14c)]=function(){const _0x3143fa=_0x3fa3c2,_0x164f90=VisuMZ[_0x3143fa(0x2bf)][_0x3143fa(0x237)];_0x164f90[_0x3143fa(0x2ab)][_0x3143fa(0x175)]&&(Input[_0x3143fa(0x173)][0x52]===undefined&&(Input[_0x3143fa(0x173)][0x52]=_0x3143fa(0x1ca))),_0x164f90[_0x3143fa(0x14d)][_0x3143fa(0x2a9)]&&(Input[_0x3143fa(0x173)][0x23]=_0x3143fa(0x149),Input[_0x3143fa(0x173)][0x24]=_0x3143fa(0x2d1));},Scene_RebindKeyboard['prototype'][_0x3fa3c2(0x17f)]=function(_0x22b3e4){const _0x334a29=_0x3fa3c2;Input[_0x334a29(0x173)][Number(_0x22b3e4)]=undefined,SoundManager[_0x334a29(0x217)](),this[_0x334a29(0x121)][_0x334a29(0x177)](),ConfigManager[_0x334a29(0x1f5)]();};function Scene_RebindGamepad(){const _0x26e584=_0x3fa3c2;this[_0x26e584(0x305)](...arguments);}Scene_RebindGamepad[_0x3fa3c2(0x16e)]=Object['create'](Scene_RebindBase['prototype']),Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2ce)]=Scene_RebindGamepad,Scene_RebindGamepad['prototype'][_0x3fa3c2(0x305)]=function(){const _0xa282b3=_0x3fa3c2;Scene_RebindBase[_0xa282b3(0x16e)][_0xa282b3(0x305)]['call'](this);},Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x204)]=function(){return!![];},Scene_RebindGamepad['prototype']['buttonAssistText3']=function(){const _0x1ec3b0=_0x3fa3c2;return Window_KeyRebinds[_0x1ec3b0(0x10d)]['buttonAssist']['reset'];},Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x303)]=function(){const _0x5761f5=_0x3fa3c2;Input[_0x5761f5(0x226)]()?(Input[_0x5761f5(0xfe)]=!![],Input[_0x5761f5(0x1ba)]=-0x1,Scene_RebindBase['prototype'][_0x5761f5(0x303)]['call'](this),this[_0x5761f5(0x2b9)]=this[_0x5761f5(0x121)][_0x5761f5(0x20a)]()):(this[_0x5761f5(0x121)][_0x5761f5(0x1e5)](),this[_0x5761f5(0x1c4)]['setText'](Window_KeyRebinds[_0x5761f5(0x10d)]['helpText'][_0x5761f5(0x2b6)]));},Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1fb)]=function(){const _0x1f5f0b=_0x3fa3c2;return Window_KeyRebinds['SETTINGS']['helpText'][_0x1f5f0b(0x24a)];},Scene_RebindGamepad['prototype'][_0x3fa3c2(0x161)]=function(){const _0x2faf8f=_0x3fa3c2;Scene_RebindBase[_0x2faf8f(0x16e)][_0x2faf8f(0x161)]['call'](this),this[_0x2faf8f(0xfa)]();},Scene_RebindGamepad['prototype'][_0x3fa3c2(0xfa)]=function(){const _0x4b9dc2=_0x3fa3c2;if(!this[_0x4b9dc2(0x17c)][_0x4b9dc2(0x19a)]())return;if(Input['_lastGamepadState']>=0x0){if([0xc,0xd,0xe,0xf][_0x4b9dc2(0x26f)](Input[_0x4b9dc2(0x1ba)]))return;this['processKeybind'](Input['_lastGamepadState']);}},Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1d0)]=function(){const _0x45c013=_0x3fa3c2;Input[_0x45c013(0xfe)]=![],Input['_lastGamepadState']=-0x1,Scene_RebindBase['prototype'][_0x45c013(0x1d0)][_0x45c013(0x206)](this);},Scene_RebindGamepad['prototype'][_0x3fa3c2(0x27c)]=function(_0x990065){const _0x50131d=_0x3fa3c2;Input[_0x50131d(0xfe)]=![],Input[_0x50131d(0x1ba)]=-0x1,Input[_0x50131d(0x2ad)][this[_0x50131d(0x2b9)]]=Input[_0x50131d(0x2ad)][_0x990065]||undefined;const _0xf54186=this[_0x50131d(0x121)][_0x50131d(0x10b)]();Input[_0x50131d(0x2ad)][_0x990065]=_0xf54186,Input['gamepadMapper'][-0x1]=undefined;},Scene_RebindGamepad[_0x3fa3c2(0x16e)][_0x3fa3c2(0x191)]=function(){const _0x42f0e4=_0x3fa3c2;VisuMZ[_0x42f0e4(0x12c)][_0x42f0e4(0x237)][_0x42f0e4(0x124)]['gamepadReset']?VisuMZ['OptionsCore'][_0x42f0e4(0x237)]['Rebind'][_0x42f0e4(0x229)]['call'](this):Input[_0x42f0e4(0x2ad)]={0x0:'ok',0x1:_0x42f0e4(0x1f0),0x2:'shift',0x3:_0x42f0e4(0x235),0x4:_0x42f0e4(0x130),0x5:_0x42f0e4(0x1c3),0xc:'up',0xd:_0x42f0e4(0x230),0xe:_0x42f0e4(0x1d7),0xf:'right'},SoundManager[_0x42f0e4(0x217)](),this[_0x42f0e4(0x121)][_0x42f0e4(0x177)](),ConfigManager[_0x42f0e4(0x1f5)]();},uiDefault[_0x3fa3c2(0x256)]=Window_Selectable[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1bb)],Window_Selectable[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1bb)]=function(){const _0x56ce9a=_0x3fa3c2;if(ConfigManager['uiHoverSelect']!==undefined)return ConfigManager['uiHoverSelect'];else{return uiDefault['hoverEnabled'][_0x56ce9a(0x206)](this);;}};function _0x10d2(){const _0xd412b9=['SoundManager_playCancel','text','Scene_Map_updateMainMultiply','Window_Options_initialize','createOptionsWindow','keyName','uiInputPosition','round','pressGamepad','ConfigManager_applyData','mhp','dropItemRate','drawText','mainFontFace','category','enabled','boxHeight','drawItemStyleIcon','button%1','processOptionsCoreFailsafe','hoverEnabled','drawTextEx','_doubleTouch','_windowTone','changePaintOpacity','textFont','close','boxWidth','playBuzzer','paintOpacity','backOpacity','_gamepadStates','Window_Options_cursorRight','Game_Temp_showFauxAnimations','SFXOKList','map','getKeyName','commandNameWindowCenter','_currentDrawingIndex','toLowerCase','174ccJXxI','selectGamepad','optionsCoreUpdateButtonPositions','updateCoreEngineOptionsCoreWindowBgStyle','categoryWindowRect','includes','dpadFmt','CheckAmPresent','optionsWindowBgType','processHandling','_scrollY','buttonY','optionsCoreUpdateWindowPositions','TextJS','addKeyboardColumns','applyDataOptionsCore','iconWidth','showFauxAnimations','updateKeybinds','Exit','VolumeShortcut','setupNewGame','This\x20button\x20cannot\x20be\x20reassigned.','bgmVolume','makeData','reduce','sounds','onKeyDown','icon','makeInputButtonString','commandStyle','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','postCreateWindows','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','isCursorMovable','change','seOK','isPressed','ButtonCommonEvents','isRepeated','iconText','version','List','HelpPosition','Scene_Battle_update','157103BpXQJT','prepareOptionsCoreSceneChange','setListWindow','Switch\x20Right','876612IamAjb','assistDropMultiplier','upPitch','process_VisuMZ_OptionsCore_Failsafe','DefaultJS','extraColumns','hitIndex','pressKeyboard','setupType','create','isBottomButtonMode','clear','parameters','_stretchScreenOptionsCore','ModernControls','playErrorKeybind','KeyboardInput','playCursorSound','gamepadMapper','height','FPSCounter','smoothScrollTo','assistMapSpeed','seCursor','innerWidth','_pageupButton','setBackgroundType','noGamepadFound','Graphics_cancelFullScreen','isForKeyboard','_replaceKeyID','callUpdateHelp','assistGodmode','getConfigValue','isItem','Categories','CoreEngine','processTouchModernControls','buttonAssistText1','_categoryWindow','canRebindInput','Game_BattlerBase_isStateResist','format','exit','_switchFullScreen','tab','switchMode','assistInstantKO','updateBackOpacity','isCommandEnabled','SFXCursorList','constructor','Remove','categoryList','home','createCategoryWindow','windowTone','Input_isTriggered','slice','playCursor','_masterVolume','playOk','bgType','requestAnimation','Game_Temp_requestAnimation','updateOptionsCoreFailsafe','makeDeepCopy','center','initOptionsCore','useItem','auto','match','Cancel\x20&\x20Menu','executeHpDamage','Press\x20a\x20gamepad\x20button\x20to\x20assign\x20this\x20control.','Switch\x20Left','commandCategory','ext','in\x20order\x20for\x20key\x20rebinds\x20to\x20work.','applySavedRebinds','makeCommandList','status','okSFXs','commandRemember','TextStr','Window_Options_cursorLeft','shift','uiMenuStyle','Graphics_switchFullScreen','Game_Enemy_dropItemRate','_loading','createInputMsgWindow','buttonAssistText5','CategoryStyle','processCursorHomeEndTrigger','keyNameAlign','Select\x20a\x20key\x20to\x20rebind/change.','itemLineRect','isRightInputMode','NUM','FUNC','mainAreaTop','Scene_Boot_start','playMasterVolumeDown','startRebind','gamepadOrder','initialize','test','smoothSelect','REBIND','updateBattleAniSpeed','commandSymbol','push','updateGamepadChange','_commandNameWindow','Game_System_initialize','length','isForbiddenKeycode','trim','itemRect','textSizeEx','downVolume','battleAniShow','inBattle','No\x20gamepad\x20is\x20detected!','Input_updateGamepadState','hasEncounterNone','_type','randomEncounters','_data','process_VisuMZ_OptionsCore_ControllerButtons','SoundManager_playCursor','processCursorMoveModernControls','ButtonPosition','isBottomHelpMode','createTextState','stringKeyMap','checkGamepadButtonPress','_returnOptionsCore','max','buzzerSFXs','_rebindState','RebindWindow_RectJS','applyData','Keyboard','commandNameWindowDrawText','deactivate','findControllerInputRebindMatch','Window_Options_processOk','_name','drawItemStyleIconText','setText','_fpsCounter','updateMainMultiplyOptionsCore','keyType','commandName','SETTINGS','ConfigManager_makeData','Left','isUseModernControls','drawBackgroundRect','resetFontSettings','_switchStretchMode','That\x20key\x20cannot\x20be\x20bound\x20to\x20a\x20control.','\x5cI[%1]%2','isInputting','HelpRebindWindow_BgType','calcWindowHeight','buttonForbidden','playLoad','Confirm','makeRebindSave','children','inputMsgWindowRect','mainAreaHeight','_battleAniSpeedLooping','_rebindWindow','ConvertParams','toUpperCase','Rebind','masterVolume','meVolume','ProcessOkJS','currentData','InputPosition','6687456abqpIc','Window_Options_drawItem','OptionsCore','ARRAYSTR','buttonAssistCategory','TextManager_getControllerInputButtonString','pageup','allowUpdateBattleAniSpeed','isRebindingEnabled','Name','Graphics_FPSCounter_switchMode','_cancelButton','meetVolumeShortcutConditions','_buttonAssistWindow','VisuMZ_0_CoreEngine','Input_isRepeated','setWindowTone','escape','_scrollX','assistSkillCosts','resetAssist','VisuMZ_4_ButtonCmnEvts\x20needs\x20to\x20be\x20updated\x20','_boxDiv','downPan','rebindWindowRect','buttonAssistText4','addEventListener','ControllerMatches','_pagedownButton','EnableRebind','cursorDown','end','updateOptionsSceneBgTypes','processOptionsCoreSoundEffects','reassignCoreEngineControls','QoL','assistConsumeItems','Game_Action_executeHpDamage','openness','100808tMFliS','process_VisuMZ_OptionsCore_DefaultLoad','LoadJS','Scene_RebindKeyboard','bind','commandStyleCheck','_text','opacity','setMasterVolume','filter','contents','playCancel','_requestFullScreen','helpText','_fullScreenOptionsCore','Scene_MenuBase_createPageButtons','update','description','expTotal','display','\x22//\x20Return\x20Boolean\x5cnreturn\x20!$gameTemp.isPlaytest()\x20&&\x20ConfigManager.assistMode;\x22','_isFPSCounterOn','iconHeight','CursorLeftJS','_handlers','seBuzzer','createHelpWindow','ARRAYEVAL','MasterVolShortcut','prototype','Game_Battler_useItem','createCommandNameWindow','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','checkActiveWindowPageUpDownHandlers','keyMapper','gamepad','DashToggleR','name','refresh','RebindWindow_BgType','createRebindWindow','Game_Troop_expTotal','processVolumeShortcut','_inputMsgWindow','upVolume','bgsVolume','shiftRemove','hasEncounterHalf','helpBgType','0abCdefghijklmnopqrstuvwxyz','Graphics_switchStretchMode','uiButtonPosition','updateCommandNameWindow','rebindControllerInputButtonString','Game_Battler_addDebuff','onTouchOk','categoryWindowBgType','addCommand','Select\x20a\x20button\x20to\x20rebind/change.','active','isActor','cancelSFXs','isEnemy','goldRate','shiftReset','ceil','helpAreaHeight','floor','addDebuff','Scene_Title_update','processOk','playBuzzerSound','assistMode','isOpen','right','setHelpWindow','onListCancel','assistGoldMultiplier','switchModeOptionsCore','setConfigValue','in\x20order\x20for\x20VisuMZ_1_OptionsCore\x20to\x20work.','OptionsSettings','ADD_REBIND_OPTIONS','changeMasterVolumeViaShortcut','updateButtonVisibility','_bypassForRebindController','isStateResist','rebind','stretchScreen','[\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2287\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Playtest\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x5cnthis.refresh();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.refresh();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Exploration\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistMapSpeed\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2282\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Map\x20Update\x20Speed\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27Normal\x27,\x20\x27Fast\x27,\x20\x27Faster\x27,\x20\x27Fastest\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x204;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x203\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x203);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x203);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistRandomEncounters\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2276\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Random\x20Encounters\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20segment\x20=\x20halfWidth\x20/\x203;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Segments\x5c\x5c\x5c\x5cnconst\x20speedText\x20=\x20[\x27None\x27,\x20\x27Half\x27,\x20\x27Normal\x27];\x5c\x5c\x5c\x5cnfor\x20(let\x20i\x20=\x200;\x20i\x20<\x203;\x20i++)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.changePaintOpacity(i\x20===\x20value);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20text\x20=\x20speedText[i];\x5c\x5c\x5c\x5cn\x20\x20\x20\x20const\x20sx\x20=\x20rect.x\x20+\x20halfWidth\x20+\x20(segment\x20*\x20i);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.drawText(text,\x20sx,\x20rect.y,\x20segment,\x20\x27center\x27);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x202\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x202);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x202;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x202);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Battle\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGodmode\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22God\x20Mode\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistResistNegatives\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Resist\x20Negative\x20Effects\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode\x20&&\x20Imported.VisuMZ_1_SkillsStatesCore;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistInstantKO\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Instant\x20K.O.\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20false;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSkillCosts\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Skill\x20Costs\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistConsumeItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Consume\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Status\x20Text\x5c\x5c\x5c\x5cnconst\x20off\x20=\x20\x27OFF\x27;\x5c\x5c\x5c\x5cnconst\x20on\x20\x20=\x20\x27ON\x27;\x5c\x5c\x5c\x5cnthis.changePaintOpacity(!value);\x5c\x5c\x5c\x5cnthis.drawText(off,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cnthis.changePaintOpacity(value);\x5c\x5c\x5c\x5cnthis.drawText(on,\x20rect.x\x20+\x20halfWidth\x20+\x20quarterWidth,\x20rect.y,\x20quarterWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20!value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnthis.playCursorSound();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20true);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20false);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(this.getConfigValue(symbol)\x20!==\x20lastValue)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol];\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol];\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Rewards\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistExpMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2288\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22EXP\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(30);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(31);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistGoldMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22314\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Gold\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(14);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(6);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistDropMultiplier\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Drop\x20Multiplier\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Gauge\x5c\x5c\x5c\x5cnconst\x20rate\x20=\x20(value\x20/\x2010).clamp(0,\x201);\x5c\x5c\x5c\x5cnconst\x20gx\x20=\x20rect.x\x20+\x20halfWidth;\x5c\x5c\x5c\x5cnconst\x20gy\x20=\x20rect.y\x20+\x20rect.height\x20-\x2014;\x5c\x5c\x5c\x5cnconst\x20fillW\x20=\x20Math.floor((halfWidth\x20-\x202)\x20*\x20rate);\x5c\x5c\x5c\x5cnconst\x20color0\x20=\x20ColorManager.gaugeBackColor();\x5c\x5c\x5c\x5cnconst\x20color1\x20=\x20ColorManager.textColor(11);\x5c\x5c\x5c\x5cnconst\x20color2\x20=\x20ColorManager.textColor(3);\x5c\x5c\x5c\x5cnthis.contents.fillRect(gx,\x20gy,\x20halfWidth,\x2012,\x20color0);\x5c\x5c\x5c\x5cnthis.contents.gradientFillRect(gx\x20+\x201,\x20gy\x20+\x201,\x20fillW,\x2010,\x20color1,\x20color2);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Value\x5c\x5c\x5c\x5cnconst\x20text\x20=\x20\x27x%1\x27.format(2\x20**\x20value);\x5c\x5c\x5c\x5cnthis.drawText(text,\x20rect.x\x20+\x20halfWidth,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22center\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnif\x20(value\x20>=\x2010\x20&&\x20(Input.isTriggered(\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22ok\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22)\x20||\x20TouchInput.isClicked()))\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x200;\x5c\x5c\x5c\x5cn}\x20else\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20+=\x201;\x5c\x5c\x5c\x5cn\x20\x20\x20\x20value\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20+=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnlet\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cnconst\x20lastValue\x20=\x20value;\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnvalue\x20-=\x201;\x5c\x5c\x5c\x5cnvalue\x20=\x20value.clamp(0,\x2010);\x5c\x5c\x5c\x5cnthis.setConfigValue(symbol,\x20value);\x5c\x5c\x5c\x5cnthis.redrawItem(this.findSymbol(symbol));\x5c\x5c\x5c\x5cnif\x20(lastValue\x20!==\x20value)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20this.playCursorSound();\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Perform\x20Actions\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnconfig[symbol]\x20=\x20ConfigManager[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20config\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[1];\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Return\x20Value\x5c\x5c\x5c\x5cnConfigManager[symbol]\x20=\x20config[symbol].clamp(0,\x2010);\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Spawners\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnItems\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22176\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Items\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataItems)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([0,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnWeapons\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2297\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Weapons\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataWeapons)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([1,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistSpawnArmors\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x22137\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Spawn\x20Armors\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Spawn\x20Items\x5c\x5c\x5c\x5cnconst\x20goods\x20=\x20[];\x5c\x5c\x5c\x5cnfor\x20(const\x20item\x20of\x20$dataArmors)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20if\x20(item\x20&&\x20item.name.trim()\x20!==\x20\x27\x27)\x20{\x5c\x5c\x5c\x5cn\x20\x20\x20\x20\x20\x20\x20\x20goods.push([2,\x20item.id,\x201,\x200]);\x5c\x5c\x5c\x5cn\x20\x20\x20\x20}\x5c\x5c\x5c\x5cn}\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Shop);\x5c\x5c\x5c\x5cnSceneManager.prepareNextScene(goods,\x20true);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22\x5c\x5c\x5c\x5cC[16]Debug\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22assistCallDebug\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x2289\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Debug\x20Menu\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Declare\x20Constants\x5c\x5c\x5c\x5cnconst\x20symbol\x20=\x20arguments[0];\x5c\x5c\x5c\x5cnconst\x20index\x20=\x20arguments[1];\x5c\x5c\x5c\x5cnconst\x20title\x20=\x20this.commandName(index);\x5c\x5c\x5c\x5cnconst\x20rect\x20=\x20this.itemLineRect(index);\x5c\x5c\x5c\x5cnconst\x20quarterWidth\x20=\x20rect.width\x20/\x204;\x5c\x5c\x5c\x5cnconst\x20halfWidth\x20=\x20rect.width\x20/\x202;\x5c\x5c\x5c\x5cnconst\x20value\x20=\x20this.getConfigValue(symbol);\x5c\x5c\x5c\x5cn\x5c\x5c\x5c\x5cn//\x20Draw\x20Command\x20Name\x5c\x5c\x5c\x5cnthis.resetFontSettings();\x5c\x5c\x5c\x5cnthis.changePaintOpacity(true);\x5c\x5c\x5c\x5cnthis.drawTextEx(title,\x20rect.x,\x20rect.y,\x20halfWidth,\x20\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22left\x5c\x5c\x5c\x5c\x5c\x5c\x5c\x22);\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Call\x20Debug\x20Menu\x5c\x5c\x5c\x5cnSceneManager.push(Scene_Debug);\x5c\x5c\x5c\x5cnthis.prepareOptionsCoreSceneChange();\x5c\x5c\x5c\x5cnSoundManager.playOk();\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22,\x22{\x5c\x22Symbol:str\x5c\x22:\x5c\x22-----------------------------\x5c\x22,\x5c\x22Icon:num\x5c\x22:\x5c\x220\x5c\x22,\x5c\x22TextStr:str\x5c\x22:\x5c\x22Untitled\x5c\x22,\x5c\x22TextJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22return\x20\x27Text\x27;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Accessibility\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22ShowJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20ConfigManager.assistMode;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22EnableJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Boolean\x5c\x5c\x5c\x5cnreturn\x20true;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ExtJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Return\x20Value\x5c\x5c\x5c\x5cnreturn\x200;\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Functions\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DrawJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22ProcessOkJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorRightJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22CursorLeftJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22Data\x5c\x22:\x5c\x22\x5c\x22,\x5c\x22DefaultJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22SaveJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22,\x5c\x22LoadJS:func\x5c\x22:\x5c\x22\x5c\x5c\x5c\x22//\x20Do\x20Nothing\x5c\x5c\x5c\x22\x5c\x22}\x22]','keyOrder','_optionsCoreFailsafeCheck','SFXCancelList','getControllerInputButtonString','Scene_Boot_onDatabaseLoaded','buttonFmt','innerHeight','Press\x20a\x20keyboard\x20button\x20to\x20assign\x20this\x20control.','keyboard','CursorRightJS','itemTextAlign','isOptionValid','_list','DataManager_setupNewGame','fullScreen','_lastGamepadState','isHoverEnabled','optionsCoreFonts','battleAniSpeed','CheckCompatibility','Symbol','parse','updateMain','requestRefresh','pagedown','_helpWindow','setCategory','6857847PqILpp','Game_Party_hasEncounterNone','ShowJS','_windowLayer','dashToggle','uiHelpPosition','deselect','seCancel','EVAL','isOpenAndActive','cancelRebinding','pressForbidden','_dataFunc','symbol','drawIcon','JSON','22MDRwio','left','cursorSFXs','maxCols','indexOf','7qcSEck','VisuMZ_0_CoreEngine\x20needs\x20to\x20be\x20updated\x20','updateEffekseer','playStaticSe','updateOptionsCoreScene','Dash','updateWindowPositions','_stretchEnabled','updateButtonPositions','downPitch','activate','7440010TPtRrd','ConfigManager_save','SoundManager_playBuzzer','alwaysDash','getKeyboardMappingByKeyType','ControllerButtons','Untitled','open','69744cpGwTb','optionsWindowRect','cancel','updateMainMultiply','processEventKeyDown','Menu','assistRandomEncounters','save','none','SaveJS','scrollX','Icon','removeAssist','inputKeyboardMessage','isTriggered','keydown','isClicked','VisuMZ_3_ButtonTriggerEvts\x20needs\x20to\x20be\x20updated\x20','Graphics_requestFullScreen','getGamepadButtonID','commandNameWindowDrawBackground','scrollY','isForGamepad','isBusy','call','createButtons','ARRAYFUNC','playSe','keyCode','10YCaFdD','VisuMZ_1_SkillsStatesCore','SoundManager_playOk','refreshWindows','60txbcwE','popScene','Scene_RebindGamepad','_scene','buttonAssistWindowRect','buttonAssistKey3','onTouchSelectModern','drawItem','playEquip','buttonAssist','setHandler','onTouchCancel','categories','onTouchSelect','touchUI','_optionsWindow','cursorPageup','onDatabaseLoaded','start','windowPadding','select','width','OptionsBgType','isGamepadConnected','getLastUsedGamepadType','addChild','gamepadReset','updateShiftRemoveShortcut','ARRAYJSON','cursorUp','Scene_Base_buttonAssistText1','cursorLeft','move','down','return\x200','buttonAssistText3','_saving','inputBgType','menu','index','Settings','ButtonTriggerEvts','playMasterVolumeUp','_lastGamepadID','processKeybind','Game_Party_hasEncounterHalf','showRegularAnimations','addWindow','drawItemKeyRebind','Cancel','displayFPS'];_0x10d2=function(){return _0xd412b9;};return _0x10d2();}function Window_OptionsCategory(){const _0x3af1df=_0x3fa3c2;this[_0x3af1df(0x305)](...arguments);}Window_OptionsCategory[_0x3fa3c2(0x2d0)]=VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x2be)],Window_OptionsCategory['prototype']=Object[_0x3fa3c2(0x2a4)](Window_HorzCommand[_0x3fa3c2(0x16e)]),Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2ce)]=Window_OptionsCategory,Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x305)]=function(_0x21b291){const _0x572b34=_0x3fa3c2;Window_HorzCommand[_0x572b34(0x16e)][_0x572b34(0x305)][_0x572b34(0x206)](this,_0x21b291),this[_0x572b34(0x170)](_0x21b291);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x110)]=function(){const _0xb9fd92=_0x3fa3c2;return Imported[_0xb9fd92(0x138)]&&Window_HorzCommand['prototype'][_0xb9fd92(0x110)][_0xb9fd92(0x206)](this);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x170)]=function(_0xeea5e5){const _0x517fe1=_0x3fa3c2,_0x3fc385=new Rectangle(0x0,0x0,_0xeea5e5[_0x517fe1(0x224)],_0xeea5e5[_0x517fe1(0x2ae)]);this[_0x517fe1(0x30d)]=new Window_Base(_0x3fc385),this[_0x517fe1(0x30d)][_0x517fe1(0x158)]=0x0,this[_0x517fe1(0x228)](this[_0x517fe1(0x30d)]),this[_0x517fe1(0x185)]();},Window_OptionsCategory[_0x3fa3c2(0x16e)]['callUpdateHelp']=function(){const _0x2b666e=_0x3fa3c2;Window_HorzCommand[_0x2b666e(0x16e)][_0x2b666e(0x2ba)]['call'](this);if(this[_0x2b666e(0x30d)])this['updateCommandNameWindow']();},Window_OptionsCategory[_0x3fa3c2(0x16e)]['updateCommandNameWindow']=function(){const _0x53d0ff=_0x3fa3c2,_0x17cbe7=this[_0x53d0ff(0x30d)];_0x17cbe7[_0x53d0ff(0x15b)][_0x53d0ff(0x2a6)]();const _0x4ef456=this['commandStyleCheck'](this[_0x53d0ff(0x236)]());if(_0x4ef456===_0x53d0ff(0x286)){const _0x47f5f5=this[_0x53d0ff(0x2fc)](this[_0x53d0ff(0x236)]());let _0x54a5a6=this[_0x53d0ff(0x10c)](this[_0x53d0ff(0x236)]());_0x54a5a6=_0x54a5a6['replace'](/\\I\[(\d+)\]/gi,''),_0x17cbe7[_0x53d0ff(0x112)](),this[_0x53d0ff(0x202)](_0x54a5a6,_0x47f5f5),this[_0x53d0ff(0x102)](_0x54a5a6,_0x47f5f5),this[_0x53d0ff(0x267)](_0x54a5a6,_0x47f5f5);}},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x202)]=function(_0x203ceb,_0x7d71c7){},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2f9)]=function(){},Window_OptionsCategory[_0x3fa3c2(0x16e)]['commandNameWindowDrawText']=function(_0x198f60,_0x4c527b){const _0x4a1622=_0x3fa3c2,_0x44471a=this[_0x4a1622(0x30d)];_0x44471a[_0x4a1622(0x24e)](_0x198f60,0x0,_0x4c527b['y'],_0x44471a[_0x4a1622(0x2b3)],'center');},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x267)]=function(_0x39c3ee,_0x3b95c3){const _0x2adb76=_0x3fa3c2,_0xb4ab3a=this['_commandNameWindow'],_0xd6074c=$gameSystem[_0x2adb76(0x222)](),_0x513348=_0x3b95c3['x']+Math[_0x2adb76(0x194)](_0x3b95c3[_0x2adb76(0x224)]/0x2)+_0xd6074c;_0xb4ab3a['x']=_0xb4ab3a['width']/-0x2+_0x513348,_0xb4ab3a['y']=Math[_0x2adb76(0x194)](_0x3b95c3[_0x2adb76(0x2ae)]/0x2);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1d9)]=function(){const _0x32d907=_0x3fa3c2;return this[_0x32d907(0x1b7)]?this['_list'][_0x32d907(0x30f)]:0x1;},Window_OptionsCategory['prototype'][_0x3fa3c2(0x299)]=function(_0x162ef4){const _0x3ebc7e=_0x3fa3c2;this[_0x3ebc7e(0x21e)]=_0x162ef4,this['refresh']();},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x161)]=function(){const _0x566837=_0x3fa3c2;Window_HorzCommand[_0x566837(0x16e)]['update']['call'](this),this[_0x566837(0x21e)]&&this[_0x566837(0x21e)][_0x566837(0x1c5)](this[_0x566837(0x128)]());},Window_OptionsCategory[_0x3fa3c2(0x16e)]['processCursorMoveModernControls']=function(){const _0x1a018a=_0x3fa3c2;if(this[_0x1a018a(0x28c)]()){const _0x30c824=this[_0x1a018a(0x236)]();Input['isRepeated'](_0x1a018a(0x1c3))&&this['cursorRight'](Input[_0x1a018a(0x1fc)]('pagedown')),Input['isRepeated']('pageup')&&this[_0x1a018a(0x22e)](Input['isTriggered'](_0x1a018a(0x130))),this[_0x1a018a(0x236)]()!==_0x30c824&&this[_0x1a018a(0x2ac)]();}},Window_OptionsCategory['prototype']['processHandling']=function(){const _0x325fc3=_0x3fa3c2;if(this[_0x325fc3(0x110)]())return;Window_HorzCommand[_0x325fc3(0x16e)][_0x325fc3(0x273)][_0x325fc3(0x206)](this);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1bb)]=function(){const _0x56815c=_0x3fa3c2;return this[_0x56815c(0x110)]()?![]:Window_HorzCommand[_0x56815c(0x16e)]['isHoverEnabled']['call'](this);},Window_OptionsCategory['prototype'][_0x3fa3c2(0x2c0)]=function(){const _0x2a35d5=_0x3fa3c2;if(this[_0x2a35d5(0x1cf)]()){TouchInput['isTriggered']()&&this[_0x2a35d5(0x21c)](!![]);if(TouchInput[_0x2a35d5(0x1fe)]())this[_0x2a35d5(0x188)]();else TouchInput['isCancelled']()&&this[_0x2a35d5(0x21a)]();}},Window_OptionsCategory['prototype']['onTouchSelect']=function(_0x4e529e){const _0x358825=_0x3fa3c2;this[_0x358825(0x110)]()?this[_0x358825(0x215)](!![]):Window_HorzCommand[_0x358825(0x16e)][_0x358825(0x21c)][_0x358825(0x206)](this,_0x4e529e);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x215)]=function(_0x4d8834){const _0x3f3696=_0x3fa3c2;this[_0x3f3696(0x258)]=![];if(this['isCursorMovable']()){const _0x56f574=this[_0x3f3696(0x236)](),_0x351644=this[_0x3f3696(0x2a1)]();_0x351644>=0x0&&_0x351644!==this[_0x3f3696(0x236)]()&&this[_0x3f3696(0x223)](_0x351644),_0x4d8834&&this[_0x3f3696(0x236)]()!==_0x56f574&&this[_0x3f3696(0x2ac)]();}},Window_OptionsCategory[_0x3fa3c2(0x16e)]['makeCommandList']=function(){const _0x22db7d=_0x3fa3c2;for(const _0x3af496 of Window_OptionsCategory[_0x22db7d(0x2d0)]){if(!_0x3af496[_0x22db7d(0x1c8)][_0x22db7d(0x206)](this))continue;const _0x2ebce9=this['commandStyle'](),_0x1d80ed=_0x3af496['Name'],_0x3e62fc=_0x3af496[_0x22db7d(0x1f9)],_0x22406f=_0x2ebce9===_0x22db7d(0x243)?_0x1d80ed:_0x22db7d(0x115)[_0x22db7d(0x2c5)](_0x3e62fc,_0x1d80ed),_0x29b8c4=_0x3af496[_0x22db7d(0x294)];this[_0x22db7d(0x18a)](_0x22406f,_0x22db7d(0x250),!![],_0x29b8c4);}},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1b5)]=function(){const _0x51b521=_0x3fa3c2;return VisuMZ['OptionsCore']['Settings'][_0x51b521(0x1a2)]['CategoryTextAlign'];},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x216)]=function(_0x340f52){const _0x3d7231=_0x3fa3c2,_0x575aa5=this[_0x3d7231(0x156)](_0x340f52);if(_0x575aa5==='iconText')this[_0x3d7231(0x107)](_0x340f52);else _0x575aa5===_0x3d7231(0x286)?this[_0x3d7231(0x253)](_0x340f52):Window_HorzCommand[_0x3d7231(0x16e)][_0x3d7231(0x216)][_0x3d7231(0x206)](this,_0x340f52);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x288)]=function(){const _0x41f259=_0x3fa3c2;return VisuMZ[_0x41f259(0x12c)][_0x41f259(0x237)][_0x41f259(0x1a2)][_0x41f259(0x2f8)];},Window_OptionsCategory['prototype'][_0x3fa3c2(0x156)]=function(_0x3891df){const _0x92c8ed=_0x3fa3c2;if(_0x3891df<0x0)return _0x92c8ed(0x243);const _0xd9127c=this['commandStyle']();if(_0xd9127c!==_0x92c8ed(0x2e1))return _0xd9127c;else{if(this['maxItems']()>0x0){const _0x1871b5=this[_0x92c8ed(0x10c)](_0x3891df);if(_0x1871b5[_0x92c8ed(0x2e2)](/\\I\[(\d+)\]/i)){const _0x5c175e=this[_0x92c8ed(0x2fc)](_0x3891df),_0x54919d=this[_0x92c8ed(0x313)](_0x1871b5)[_0x92c8ed(0x224)];return _0x54919d<=_0x5c175e[_0x92c8ed(0x224)]?_0x92c8ed(0x292):_0x92c8ed(0x286);}}}return _0x92c8ed(0x243);},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x107)]=function(_0x1114b2){const _0x3eb9e7=_0x3fa3c2,_0x16f311=this[_0x3eb9e7(0x2fc)](_0x1114b2),_0x3ca0fe=this[_0x3eb9e7(0x10c)](_0x1114b2),_0x48f185=this[_0x3eb9e7(0x313)](_0x3ca0fe)[_0x3eb9e7(0x224)];this[_0x3eb9e7(0x25a)](this[_0x3eb9e7(0x2cc)](_0x1114b2));const _0x14c9ac=this[_0x3eb9e7(0x1b5)]();if(_0x14c9ac===_0x3eb9e7(0x19b))this[_0x3eb9e7(0x257)](_0x3ca0fe,_0x16f311['x']+_0x16f311[_0x3eb9e7(0x224)]-_0x48f185,_0x16f311['y'],_0x48f185);else{if(_0x14c9ac===_0x3eb9e7(0x2de)){const _0x3566b3=_0x16f311['x']+Math['floor']((_0x16f311[_0x3eb9e7(0x224)]-_0x48f185)/0x2);this[_0x3eb9e7(0x257)](_0x3ca0fe,_0x3566b3,_0x16f311['y'],_0x48f185);}else this[_0x3eb9e7(0x257)](_0x3ca0fe,_0x16f311['x'],_0x16f311['y'],_0x48f185);}},Window_OptionsCategory[_0x3fa3c2(0x16e)][_0x3fa3c2(0x253)]=function(_0x4faea3){const _0x104272=_0x3fa3c2;this[_0x104272(0x10c)](_0x4faea3)[_0x104272(0x2e2)](/\\I\[(\d+)\]/i);const _0x4ed7d9=Number(RegExp['$1'])||0x0,_0xed236d=this['itemLineRect'](_0x4faea3),_0xf4ac69=_0xed236d['x']+Math['floor']((_0xed236d[_0x104272(0x224)]-ImageManager[_0x104272(0x27a)])/0x2),_0x293f83=_0xed236d['y']+(_0xed236d[_0x104272(0x2ae)]-ImageManager[_0x104272(0x167)])/0x2;this[_0x104272(0x1d4)](_0x4ed7d9,_0xf4ac69,_0x293f83);},VisuMZ['OptionsCore'][_0x3fa3c2(0x245)]=Window_Options['prototype']['initialize'],Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x305)]=function(_0x323f8c){const _0x56bfdb=_0x3fa3c2;this['_name']=null,this[_0x56bfdb(0xf2)]=null,VisuMZ[_0x56bfdb(0x12c)][_0x56bfdb(0x245)][_0x56bfdb(0x206)](this,_0x323f8c);},Window_Options['prototype'][_0x3fa3c2(0x1c5)]=function(_0x1fcee6){const _0x3817c1=_0x3fa3c2;if(!_0x1fcee6)return;if(_0x1fcee6['name']===this[_0x3817c1(0x106)])return;this[_0x3817c1(0x106)]=_0x1fcee6[_0x3817c1(0x176)],this[_0x3817c1(0xf2)]=_0x1fcee6['ext'],this[_0x3817c1(0x2b0)](0x0,0x0),this[_0x3817c1(0x177)]();if(this[_0x3817c1(0x110)]())this[_0x3817c1(0x307)](0x0);},Window_Options['prototype'][_0x3fa3c2(0x2bc)]=function(_0x199791){return ConfigManager[_0x199791];},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a0)]=function(_0x4869c2,_0x31b6c9){ConfigManager[_0x4869c2]=_0x31b6c9;},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x298)]=function(){const _0xacac81=_0x3fa3c2;$gameTemp[_0xacac81(0xfb)]={'category':SceneManager[_0xacac81(0x212)][_0xacac81(0x2c2)][_0xacac81(0x236)](),'index':this[_0xacac81(0x236)](),'scrollX':this[_0xacac81(0x13c)],'scrollY':this[_0xacac81(0x274)]};},Window_Options['prototype'][_0x3fa3c2(0x132)]=function(){const _0x8ebfe4=_0x3fa3c2;return Scene_Options[_0x8ebfe4(0x1a3)];},Window_Options['prototype']['isUseModernControls']=function(){const _0x368ee5=_0x3fa3c2;return Imported[_0x368ee5(0x138)]&&Window_HorzCommand['prototype']['isUseModernControls'][_0x368ee5(0x206)](this);},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0xf5)]=function(){const _0x5e5d88=_0x3fa3c2;if(this[_0x5e5d88(0x28c)]()){const _0x513b06=this['index']();Input[_0x5e5d88(0x291)](_0x5e5d88(0x230))&&(Input['isPressed'](_0x5e5d88(0x2f1))?this['cursorPagedown']():this[_0x5e5d88(0x148)](Input['isTriggered'](_0x5e5d88(0x230)))),Input[_0x5e5d88(0x291)]('up')&&(Input[_0x5e5d88(0x28f)](_0x5e5d88(0x2f1))?this[_0x5e5d88(0x21f)]():this[_0x5e5d88(0x22c)](Input['isTriggered']('up'))),Input[_0x5e5d88(0x291)](_0x5e5d88(0x19b))&&this['cursorRight'](Input[_0x5e5d88(0x1fc)](_0x5e5d88(0x19b))),Input[_0x5e5d88(0x291)](_0x5e5d88(0x1d7))&&this[_0x5e5d88(0x22e)](Input[_0x5e5d88(0x1fc)](_0x5e5d88(0x1d7))),this[_0x5e5d88(0x236)]()!==_0x513b06&&this[_0x5e5d88(0x2ac)]();}},VisuMZ[_0x3fa3c2(0x12c)]['Window_Options_processOk']=Window_Options['prototype'][_0x3fa3c2(0x197)],Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x197)]=function(){const _0x5d59b8=_0x3fa3c2,_0x265472=this[_0x5d59b8(0x236)](),_0x342e23=this['commandSymbol'](_0x265472);if(!this['isCommandEnabled'](_0x265472)){this[_0x5d59b8(0x198)]();return;}try{this[_0x5d59b8(0x1d2)][_0x265472][_0x5d59b8(0x127)][_0x5d59b8(0x206)](this,_0x342e23,_0x265472);}catch(_0x1b0e0f){VisuMZ['OptionsCore'][_0x5d59b8(0x105)]['call'](this);}},VisuMZ['OptionsCore'][_0x3fa3c2(0x262)]=Window_Options[_0x3fa3c2(0x16e)]['cursorRight'],Window_Options[_0x3fa3c2(0x16e)]['cursorRight']=function(){const _0x5b5c69=_0x3fa3c2,_0x5de9cc=this[_0x5b5c69(0x236)](),_0x2bc4a0=this[_0x5b5c69(0x30a)](_0x5de9cc);if(!this[_0x5b5c69(0x2cc)](_0x5de9cc)){this[_0x5b5c69(0x198)]();return;}try{this['_dataFunc'][_0x5de9cc][_0x5b5c69(0x1b4)][_0x5b5c69(0x206)](this,_0x2bc4a0,_0x5de9cc);}catch(_0x288657){VisuMZ['OptionsCore'][_0x5b5c69(0x262)][_0x5b5c69(0x206)](this);}},VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x2f0)]=Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x22e)],Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x22e)]=function(){const _0x27e1b3=_0x3fa3c2,_0x5a8e7e=this['index'](),_0x14f46f=this[_0x27e1b3(0x30a)](_0x5a8e7e);if(!this[_0x27e1b3(0x2cc)](_0x5a8e7e)){this[_0x27e1b3(0x198)]();return;}try{this[_0x27e1b3(0x1d2)][_0x5a8e7e][_0x27e1b3(0x168)][_0x27e1b3(0x206)](this,_0x14f46f,_0x5a8e7e);}catch(_0x43b076){VisuMZ['OptionsCore'][_0x27e1b3(0x2f0)]['call'](this);}},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2eb)]=function(){const _0x927440=_0x3fa3c2;if(!this['_data'])return;this[_0x927440(0x1d2)]=[];for(const _0x17e66d of this[_0x927440(0xf2)]){if(!_0x17e66d[_0x927440(0x1c8)][_0x927440(0x206)](this))continue;let _0x520788=_0x17e66d[_0x927440(0x2ef)];if(['',_0x927440(0x1ec)]['includes'](_0x520788))_0x520788=_0x17e66d[_0x927440(0x277)][_0x927440(0x206)](this);const _0x246276=_0x17e66d[_0x927440(0x1f9)];_0x246276>0x0&&(_0x520788=_0x927440(0x115)[_0x927440(0x2c5)](_0x246276,_0x520788));const _0x38c4fb=_0x17e66d[_0x927440(0x1bf)],_0x3abe76=_0x17e66d['EnableJS']['call'](this),_0x4f8163=_0x17e66d['ExtJS'][_0x927440(0x206)](this);this['addCommand'](_0x520788,_0x38c4fb,_0x3abe76,_0x4f8163),this[_0x927440(0x1d2)][_0x927440(0x30b)](_0x17e66d);}},VisuMZ[_0x3fa3c2(0x12c)]['Window_Options_drawItem']=Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x216)],Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x216)]=function(_0x49ddbb){const _0x266dce=_0x3fa3c2;this[_0x266dce(0x112)](),this[_0x266dce(0x25a)](this[_0x266dce(0x2cc)](_0x49ddbb));const _0x5e4fa8=this['_list'][_0x49ddbb][_0x266dce(0x1d3)];this['_currentDrawingIndex']=_0x49ddbb;try{this[_0x266dce(0x1d2)][_0x49ddbb]['DrawJS'][_0x266dce(0x206)](this,_0x5e4fa8,_0x49ddbb);}catch(_0x167ac7){VisuMZ[_0x266dce(0x12c)][_0x266dce(0x12b)]['call'](this,_0x49ddbb);}this[_0x266dce(0x268)]=undefined;},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1a5)]=function(){const _0x45bbf4=_0x3fa3c2;SceneManager[_0x45bbf4(0x212)][_0x45bbf4(0x1a5)]();},Window_Options['prototype'][_0x3fa3c2(0x1e3)]=function(){const _0x41d95a=_0x3fa3c2;SceneManager[_0x41d95a(0x212)][_0x41d95a(0x26c)]();},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1e1)]=function(){const _0x434252=_0x3fa3c2;SceneManager['_scene'][_0x434252(0x276)]();},Window_Options[_0x3fa3c2(0x16e)]['refreshWindows']=function(){const _0x5a0fc5=_0x3fa3c2;if(SceneManager[_0x5a0fc5(0x212)]['constructor']!==Scene_Options)return;SceneManager[_0x5a0fc5(0x212)][_0x5a0fc5(0x20e)]();},Window_Options[_0x3fa3c2(0x16e)][_0x3fa3c2(0x24e)]=function(_0x576192,_0x4dc6cd,_0x4cb9c8,_0x1cc7a5,_0x1c89f8){const _0x28b9a2=_0x3fa3c2,_0x43ce62=this[_0x28b9a2(0x15b)][_0x28b9a2(0x25f)];this[_0x28b9a2(0x268)]>=0x0&&(!this[_0x28b9a2(0x2cc)](this['_currentDrawingIndex'])&&this[_0x28b9a2(0x25a)](![])),Window_Command['prototype']['drawText']['call'](this,_0x576192,_0x4dc6cd,_0x4cb9c8,_0x1cc7a5,_0x1c89f8),this[_0x28b9a2(0x15b)][_0x28b9a2(0x25f)]=_0x43ce62;},Window_Options[_0x3fa3c2(0x16e)]['drawTextEx']=function(_0x3d38d1,_0x20441f,_0x288bd5,_0x2d885f){const _0x1b7032=_0x3fa3c2;this[_0x1b7032(0x112)]();const _0x285c06=this[_0x1b7032(0x15b)][_0x1b7032(0x25f)];this['_currentDrawingIndex']>=0x0&&(!this['isCommandEnabled'](this['_currentDrawingIndex'])&&this[_0x1b7032(0x25a)](![]));const _0x30b27b=this[_0x1b7032(0xf8)](_0x3d38d1,_0x20441f,_0x288bd5,_0x2d885f);this['processAllText'](_0x30b27b);const _0x4142b3=_0x30b27b['outputWidth'];return this[_0x1b7032(0x15b)][_0x1b7032(0x25f)]=_0x285c06,_0x4142b3;};function Window_RebindHelp(){const _0x51a638=_0x3fa3c2;this[_0x51a638(0x305)](...arguments);}Window_RebindHelp[_0x3fa3c2(0x16e)]=Object[_0x3fa3c2(0x2a4)](Window_Help[_0x3fa3c2(0x16e)]),Window_RebindHelp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2ce)]=Window_RebindHelp,Window_RebindHelp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x305)]=function(_0x584cb9){const _0x18ab46=_0x3fa3c2;Window_Help[_0x18ab46(0x16e)][_0x18ab46(0x305)]['call'](this,_0x584cb9);},Window_RebindHelp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2cb)]=function(){const _0x205e9b=_0x3fa3c2;this[_0x205e9b(0x260)]=0xff;},Window_RebindHelp[_0x3fa3c2(0x16e)][_0x3fa3c2(0x177)]=function(){const _0x1ae5d4=_0x3fa3c2;this['contents'][_0x1ae5d4(0x2a6)]();const _0x18c27c=this[_0x1ae5d4(0x313)](this[_0x1ae5d4(0x157)]),_0x492e5b=Math[_0x1ae5d4(0x249)]((this['innerWidth']-_0x18c27c[_0x1ae5d4(0x224)])/0x2),_0x45be5b=Math[_0x1ae5d4(0x249)]((this[_0x1ae5d4(0x1b1)]-_0x18c27c[_0x1ae5d4(0x2ae)])/0x2);this[_0x1ae5d4(0x257)](this['_text'],_0x492e5b,_0x45be5b);};function Window_KeyRebinds(){const _0x4f274a=_0x3fa3c2;this[_0x4f274a(0x305)](...arguments);}Window_KeyRebinds[_0x3fa3c2(0x16e)]=Object[_0x3fa3c2(0x2a4)](Window_Command[_0x3fa3c2(0x16e)]),Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2ce)]=Window_KeyRebinds,Window_KeyRebinds[_0x3fa3c2(0x10d)]={'bgType':VisuMZ[_0x3fa3c2(0x12c)]['Settings']['Rebind'][_0x3fa3c2(0x178)]??0x0,'keyOrder':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind'][_0x3fa3c2(0x1ab)]??['up','left',_0x3fa3c2(0x230),_0x3fa3c2(0x19b),'ok',_0x3fa3c2(0x13b),_0x3fa3c2(0x2f1),_0x3fa3c2(0x2c8),_0x3fa3c2(0x130),_0x3fa3c2(0x1c3)],'gamepadOrder':VisuMZ[_0x3fa3c2(0x12c)]['Settings']['Rebind'][_0x3fa3c2(0x304)]??['up',_0x3fa3c2(0x1d7),'down',_0x3fa3c2(0x19b),'ok','cancel',_0x3fa3c2(0x235),_0x3fa3c2(0x2f1),'pageup','pagedown'],'keyNameAlign':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x2fa)]??_0x3fa3c2(0x2de),'rebindAlign':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)]['rebindAlign']??_0x3fa3c2(0x2de),'buttonAssist':{'remove':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind'][_0x3fa3c2(0x1fa)]??_0x3fa3c2(0x2cf),'reset':VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x13e)]??'Reset','confirm':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)]['confirmAssist']??_0x3fa3c2(0x124),'cancel':VisuMZ[_0x3fa3c2(0x12c)]['Settings']['Rebind']['cancelAssist']??_0x3fa3c2(0x27d)},'helpText':{'selectKeyboard':VisuMZ[_0x3fa3c2(0x12c)]['Settings'][_0x3fa3c2(0x124)]['selectKeyboard']??_0x3fa3c2(0x2fb),'selectGamepad':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)]['Rebind'][_0x3fa3c2(0x26b)]??_0x3fa3c2(0x18b),'pressKeyboard':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x2a2)]??_0x3fa3c2(0x1b2),'pressGamepad':VisuMZ[_0x3fa3c2(0x12c)][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x24a)]??_0x3fa3c2(0x2e5),'pressForbidden':VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x1d1)]??_0x3fa3c2(0x114),'buttonForbidden':VisuMZ[_0x3fa3c2(0x12c)]['Settings'][_0x3fa3c2(0x124)][_0x3fa3c2(0x119)]??_0x3fa3c2(0x280),'noGamepadFound':VisuMZ['OptionsCore'][_0x3fa3c2(0x237)][_0x3fa3c2(0x124)][_0x3fa3c2(0x2b6)]??_0x3fa3c2(0xed)}},Window_KeyRebinds['prototype']['initialize']=function(_0x4918b7){const _0x51f183=_0x3fa3c2;this[_0x51f183(0x2a3)](),Window_Command[_0x51f183(0x16e)][_0x51f183(0x305)]['call'](this,_0x4918b7),this['select'](this[_0x51f183(0x2b8)]()?0x2:0x1);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2a3)]=function(){const _0x1f5daa=_0x3fa3c2,_0x281b8d=SceneManager[_0x1f5daa(0x212)][_0x1f5daa(0x2ce)][_0x1f5daa(0x176)];if(_0x281b8d===_0x1f5daa(0x154))this[_0x1f5daa(0xf0)]=_0x1f5daa(0x1b3);else _0x281b8d===_0x1f5daa(0x211)?this[_0x1f5daa(0xf0)]=_0x1f5daa(0x174):this[_0x1f5daa(0xf0)]=_0x1f5daa(0x1f6);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2b8)]=function(){const _0x3e0116=_0x3fa3c2;return this[_0x3e0116(0xf0)]===_0x3e0116(0x1b3);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x204)]=function(){const _0x5e97e4=_0x3fa3c2;return this[_0x5e97e4(0xf0)]===_0x5e97e4(0x174);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x1d9)]=function(){const _0x127e12=_0x3fa3c2;return 0x1+this[_0x127e12(0x2a0)]();},Window_KeyRebinds[_0x3fa3c2(0x16e)]['extraColumns']=function(){const _0xf090dd=_0x3fa3c2;if(this[_0xf090dd(0x2b8)]())return 0x2;else{if(this[_0xf090dd(0x204)]())return 0x1;}return 0x0;},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x20a)]=function(){const _0x2350f1=_0x3fa3c2;if(this['isForKeyboard']()){const _0x2fc4b3=this[_0x2350f1(0x236)](),_0x573d62=Number(this[_0x2350f1(0x10c)](_0x2fc4b3)),_0x13556c=String(this['_list'][_0x2fc4b3][_0x2350f1(0x2e8)]||''),_0x23b77f=Input[_0x2350f1(0x1ea)](_0x13556c)||[];return Number(_0x23b77f[_0x573d62]??-0x1);}else{if(this[_0x2350f1(0x204)]()){const _0x4595a7=this[_0x2350f1(0x236)](),_0x14c64d=String(this[_0x2350f1(0x1b7)][_0x4595a7][_0x2350f1(0x2e8)]||'');return Input[_0x2350f1(0x201)](_0x14c64d)[0x0];}}},Window_KeyRebinds['prototype'][_0x3fa3c2(0x10b)]=function(){const _0x376167=_0x3fa3c2,_0x1cef58=this['index']();return String(this[_0x376167(0x1b7)][_0x1cef58][_0x376167(0x2e8)]||'');},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x223)]=function(_0xffa93a){const _0x39484a=_0x3fa3c2;if(Input[_0x39484a(0x1fc)]('home'))_0xffa93a=this[_0x39484a(0x2b8)]()?0x2:0x1;if(this[_0x39484a(0x2b8)]()){if(_0xffa93a%this[_0x39484a(0x1d9)]()===0x1)return;}if(_0xffa93a%this[_0x39484a(0x1d9)]()===0x0)return;Window_Command[_0x39484a(0x16e)][_0x39484a(0x223)][_0x39484a(0x206)](this,_0xffa93a);},Window_KeyRebinds[_0x3fa3c2(0x16e)]['playOkSound']=function(){const _0x1da450=_0x3fa3c2;this[_0x1da450(0x204)]()&&!Input[_0x1da450(0x226)]()?this[_0x1da450(0x198)]():Window_Command[_0x1da450(0x16e)]['playOkSound'][_0x1da450(0x206)](this);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x198)]=function(){const _0x39c9db=_0x3fa3c2;Window_Command[_0x39c9db(0x16e)][_0x39c9db(0x198)]['call'](this),this[_0x39c9db(0x204)]()&&this[_0x39c9db(0x1c4)]&&this[_0x39c9db(0x1c4)]['setText'](Window_KeyRebinds[_0x39c9db(0x10d)]['helpText']['buttonForbidden']);},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x2eb)]=function(){const _0x1e2497=_0x3fa3c2,_0x54d75a=Window_KeyRebinds['SETTINGS'],_0x1d58f3=this[_0x1e2497(0x2b8)]()?_0x54d75a[_0x1e2497(0x1ab)]:_0x54d75a[_0x1e2497(0x304)];for(const _0x10ab00 of _0x1d58f3){this[_0x1e2497(0x278)](_0x10ab00);}},Window_KeyRebinds[_0x3fa3c2(0x16e)]['addKeyboardColumns']=function(_0x2b3800){const _0x252507=_0x3fa3c2,_0x307968=this[_0x252507(0x2a0)]();if(_0x307968<=0x0)return;this[_0x252507(0x18a)](_0x2b3800,_0x252507(0x247),![],_0x2b3800);for(let _0x3b0352=0x0;_0x3b0352<_0x307968;_0x3b0352++){const _0x4d1cdf=this[_0x252507(0x2c3)](_0x2b3800,_0x3b0352);this[_0x252507(0x18a)](String(_0x3b0352),_0x252507(0x1a8),_0x4d1cdf,_0x2b3800);}},Window_KeyRebinds['prototype'][_0x3fa3c2(0x2c3)]=function(_0xaf601b,_0x2779ed){const _0x53a5e1=_0x3fa3c2;if(this[_0x53a5e1(0x2b8)]()){if(_0x2779ed===0x0)return![];}else{if(this['isForGamepad']()){if(['up',_0x53a5e1(0x1d7),_0x53a5e1(0x230),_0x53a5e1(0x19b)][_0x53a5e1(0x26f)](_0xaf601b))return![];}}return!![];},Window_KeyRebinds[_0x3fa3c2(0x16e)]['drawItemBackground']=function(_0x5c6fd6){const _0x3d0d0b=_0x3fa3c2;if(_0x5c6fd6%this[_0x3d0d0b(0x1d9)]()===0x0)return;const _0x5253bb=this[_0x3d0d0b(0x312)](_0x5c6fd6);this[_0x3d0d0b(0x111)](_0x5253bb);},Window_KeyRebinds['prototype'][_0x3fa3c2(0x216)]=function(_0x521481){const _0x33512a=_0x3fa3c2,_0x485e00=this[_0x33512a(0x30a)](_0x521481);if(_0x485e00===_0x33512a(0x247))this['drawItemKeyName'](_0x521481);else _0x485e00===_0x33512a(0x1a8)&&this[_0x33512a(0x23f)](_0x521481);},Window_KeyRebinds[_0x3fa3c2(0x16e)]['drawItemKeyName']=function(_0x227d5c){const _0x14fd30=_0x3fa3c2,_0x4782f7=Window_KeyRebinds['SETTINGS'],_0x99c108=this['itemLineRect'](_0x227d5c),_0x27a17d=TextManager[_0x14fd30(0x308)][this['_list'][_0x227d5c][_0x14fd30(0x2e8)]]||'',_0x10ea60=this[_0x14fd30(0x313)](_0x27a17d)[_0x14fd30(0x224)],_0x5ab634=_0x4782f7[_0x14fd30(0x2fa)]||_0x14fd30(0x2de);this[_0x14fd30(0x112)](),this[_0x14fd30(0x25a)](!![]);if(_0x5ab634===_0x14fd30(0x19b))this[_0x14fd30(0x257)](_0x27a17d,_0x99c108['x']+_0x99c108[_0x14fd30(0x224)]-_0x10ea60,_0x99c108['y'],_0x10ea60);else{if(_0x5ab634===_0x14fd30(0x2de)){const _0x1a3ffa=_0x99c108['x']+Math[_0x14fd30(0x194)]((_0x99c108[_0x14fd30(0x224)]-_0x10ea60)/0x2);this['drawTextEx'](_0x27a17d,_0x1a3ffa,_0x99c108['y'],_0x10ea60);}else this[_0x14fd30(0x257)](_0x27a17d,_0x99c108['x'],_0x99c108['y'],_0x10ea60);}},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x23f)]=function(_0x2a4197){const _0x1c009c=_0x3fa3c2,_0xfcabfe=Window_KeyRebinds[_0x1c009c(0x10d)],_0x4136b4=this[_0x1c009c(0x2fc)](_0x2a4197),_0x42b985=Number(this[_0x1c009c(0x10c)](_0x2a4197)),_0x99fe98=String(this[_0x1c009c(0x1b7)][_0x2a4197][_0x1c009c(0x2e8)]||'');$gameTemp[_0x1c009c(0x1a6)]=this[_0x1c009c(0x204)]();const _0x200a6e=this[_0x1c009c(0x266)](_0x42b985,_0x99fe98);$gameTemp[_0x1c009c(0x1a6)]=undefined;const _0x2f5e31=this[_0x1c009c(0x313)](_0x200a6e)['width'],_0x15d028=_0xfcabfe[_0x1c009c(0x2fa)]||_0x1c009c(0x2de);this[_0x1c009c(0x112)](),this['changePaintOpacity'](this[_0x1c009c(0x2cc)](_0x2a4197));if(_0x15d028===_0x1c009c(0x19b))this[_0x1c009c(0x257)](_0x200a6e,_0x4136b4['x']+_0x4136b4[_0x1c009c(0x224)]-_0x2f5e31,_0x4136b4['y'],_0x2f5e31);else{if(_0x15d028==='center'){const _0x546d5f=_0x4136b4['x']+Math[_0x1c009c(0x194)]((_0x4136b4[_0x1c009c(0x224)]-_0x2f5e31)/0x2);this[_0x1c009c(0x257)](_0x200a6e,_0x546d5f,_0x4136b4['y'],_0x2f5e31);}else this['drawTextEx'](_0x200a6e,_0x4136b4['x'],_0x4136b4['y'],_0x2f5e31);}},Window_KeyRebinds[_0x3fa3c2(0x16e)][_0x3fa3c2(0x266)]=function(_0x34093c,_0x30fce9){const _0x20a31b=_0x3fa3c2;if(this[_0x20a31b(0x2b8)]()){const _0x4302f3=Input[_0x20a31b(0x1ea)](_0x30fce9)||[],_0x276bb9=_0x4302f3[_0x34093c];if(TextManager[_0x20a31b(0xf9)][_0x276bb9]===undefined)return'-';const _0x2c66c6=[TextManager[_0x20a31b(0xf9)][_0x276bb9]];return TextManager[_0x20a31b(0x287)](_0x2c66c6);}else{if(this[_0x20a31b(0x204)]()){const _0x226119=Input[_0x20a31b(0x227)]();if(_0x226119!==_0x20a31b(0x101))return TextManager[_0x20a31b(0x1ae)](_0x226119,_0x30fce9);if(['up',_0x20a31b(0x1d7),_0x20a31b(0x230),_0x20a31b(0x19b)][_0x20a31b(0x26f)](_0x30fce9)){const _0x5aca62=TextManager[_0x20a31b(0x308)][_0x20a31b(0x270)];return _0x5aca62['format'](TextManager[_0x20a31b(0x308)][_0x30fce9]);}else{const _0x1fffaa=TextManager[_0x20a31b(0x308)]['buttonFmt'];return _0x1fffaa['format'](Input['getGamepadButtonID'](_0x30fce9));}}else return'';}},Window_KeyRebinds['prototype'][_0x3fa3c2(0x161)]=function(){const _0x3e1464=_0x3fa3c2;Window_Command[_0x3e1464(0x16e)][_0x3e1464(0x161)]['call'](this),this[_0x3e1464(0x22a)](),this['updateGamepadChange']();},Window_KeyRebinds[_0x3fa3c2(0x16e)]['updateShiftRemoveShortcut']=function(){const _0x200ff2=_0x3fa3c2;if(!this['isOpenAndActive']())return;if(!Input[_0x200ff2(0x1fc)]('shift'))return;this[_0x200ff2(0x2b8)]()&&this['keyCode']()>=0x0&&SceneManager[_0x200ff2(0x212)][_0x200ff2(0x17f)](this[_0x200ff2(0x20a)]()),this[_0x200ff2(0x204)]()&&SceneManager[_0x200ff2(0x212)][_0x200ff2(0x191)]();},Window_KeyRebinds['prototype'][_0x3fa3c2(0x30c)]=function(){const _0x1e5946=_0x3fa3c2;if(!this[_0x1e5946(0x204)]())return;if(this[_0x1e5946(0x23a)]===Input['getLastUsedGamepadType']())return;this['_lastGamepadID']=Input[_0x1e5946(0x227)](),this['refresh']();},Window_KeyRebinds[_0x3fa3c2(0x16e)]['updateHelp']=function(){const _0x1b22e8=_0x3fa3c2,_0x398827=Window_KeyRebinds[_0x1b22e8(0x10d)][_0x1b22e8(0x15e)];this[_0x1b22e8(0x1c4)][_0x1b22e8(0x2a6)]();if(this[_0x1b22e8(0x2b8)]())this[_0x1b22e8(0x1c4)][_0x1b22e8(0x108)](_0x398827['selectKeyboard']);else this[_0x1b22e8(0x204)]()&&this[_0x1b22e8(0x1c4)]['setText'](_0x398827[_0x1b22e8(0x26b)]);};